<?php

function config_carte_form($form, &$form_state)
{
    $form['gmap_key'] = array(
        '#title' => 'Clé Google Maps',
        '#type' => 'textfield',
        '#default_value' => variable_get('gmapKey'),
        '#description' => 'Clé unique fournie par Google pour pouvoir utiliser Google Maps'
    );

    $form['map_cache_delay'] = array(
        '#title' => 'Délai d\'expiration du cache des données KML (secondes).',
        '#type' => 'textfield',
        '#default_value' => variable_get('mapCacheDelay'),
        '#description' => 'Les données KML de la carte interactive sont mises en cache pour accélerer leur chargement. Vous pouvez choisir ici la fréquence de rafraîchissement de ces données (défaut: 24h).<br /><a href="/admin/config/system/config_carte/clear_map_cache" onclick="return confirm(\'Attention, les options non sauvegardées seront perdues\')">Vider manuellement le cache de la carte</a>',
    );
    
    $form['activites'] = array(
        '#title' => 'Activités',
        '#type' => 'fieldset',
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );
    
    $listeActivites = getListeActivites();
    $optionsActivites = array();
    
    foreach($listeActivites as $activite)
    {
        $optionsActivites[$activite->id] = $activite->nom;
    }
    
    $form['activites']['liste_activites'] = array(
        '#title' => 'Sélectionner les activités à afficher sur la carte',
        '#type' => 'checkboxes',
        '#options' => $optionsActivites,
        '#default_value' => unserialize(variable_get('mapActivities')),
    );
    
    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => 'Enregistrer',
    );
    
    return $form;
}

function config_carte_form_submit($form, &$form_state)
{
    $values = $form_state['values'];
    
    variable_set('gmapKey', $values['gmap_key']);
    variable_set('mapCacheDelay', $values['map_cache_delay']);
    
    $listeActivites = $values['liste_activites'];
    $activitesSelectionnees = array();
    
    foreach ($listeActivites as $idActivite => $value)
    {
        if ($value > 0){
            $activitesSelectionnees[] = $idActivite;
        }
    }
    
    variable_set('mapActivities', serialize($activitesSelectionnees));
    
    drupal_set_message('Les options ont bien été enregistrées');
}

?>
