const MAX_RESULTS = 80;
const NUM_RESULTS_PER_PAGE = 8;
const MAX_NUM_PAGES = MAX_RESULTS / NUM_RESULTS_PER_PAGE;

var imageSearch;
var query;
var results;
var currentPage;
var numPages;

jQuery(document).ready(function()
{	
	imageSearch = new google.search.ImageSearch();
	imageSearch.setSearchCompleteCallback(this, getSearchResults, null);
	imageSearch.setResultSetSize(NUM_RESULTS_PER_PAGE);
	
	jQuery('#searchform').submit(function()
	{
		launchSearch(jQuery('#searchbox').val());					
		return false;
	});
	jQuery('#searchbox').keyup(function()
	{
		launchSearch(jQuery('#searchbox').val());					
		return false;
	});
	
	jQuery('#searchbox').focus();
});

function launchSearch(q)
{				
	//console.log("Searching '" + q + "'");
	
	query = q;
	
	results = [];
	currentPage = 0;
	
	jQuery("#results").html("");
	
	imageSearch.execute(query);
}

function getSearchResults()
{
	numPages = imageSearch.cursor != undefined ? imageSearch.cursor.pages.length : -1;
	
	if (numPages == -1)
	{
		displayNoResults();
		return;
	}
	
	appendResults(imageSearch.results);
	
	if (++currentPage < numPages)
		imageSearch.gotoPage(currentPage);
	else
		searchComplete();
}

function appendResults(data)
{
	var numResults = data.length;
	
	for (var i = 0; i < numResults; i++)
	{
		var thumbUrl = data[i].tbUrl;
		var fullUrl = data[i].url;
		
		jQuery("#results").append('<a href="' + fullUrl + '"><img src="' + thumbUrl + '" /></a>');
	}
	
	results = results.concat(data.results);
}

function searchComplete()
{
	//console.log("Search complete.");
}

function displayNoResults()
{
	jQuery("#results").html("Aucun r&eacute;sultat trouv&eacute;...");
}