<?php
/**
 * @file
 * md_blog.features.inc
 */

/**
 * Implements hook_ctools_plugin_api().
 */
function md_blog_ctools_plugin_api($module = NULL, $api = NULL) {
  if ($module == "context" && $api == "context") {
    return array("version" => "3");
  }
}

/**
 * Implements hook_views_api().
 */
function md_blog_views_api($module = NULL, $api = NULL) {
  return array("api" => "3.0");
}

/**
 * Implements hook_image_default_styles().
 */
function md_blog_image_default_styles() {
  $styles = array();

  // Exported image style: image_blog_classic_fullwidth__1140x_608_.
  $styles['image_blog_classic_fullwidth__1140x_608_'] = array(
    'label' => 'Image blog classic fullwidth (1140x 608)',
    'effects' => array(
      2 => array(
        'name' => 'image_scale_and_crop',
        'data' => array(
          'width' => 1140,
          'height' => 608,
        ),
        'weight' => 1,
      ),
    ),
  );

  // Exported image style: image_blog_classic_sidebar__750_x_400_.
  $styles['image_blog_classic_sidebar__750_x_400_'] = array(
    'label' => 'Image blog classic sidebar (750 x 400)',
    'effects' => array(
      1 => array(
        'name' => 'image_scale_and_crop',
        'data' => array(
          'width' => 750,
          'height' => 400,
        ),
        'weight' => 1,
      ),
    ),
  );

  // Exported image style: image_grid_2_col__360_x_198_.
  $styles['image_grid_2_col__360_x_198_'] = array(
    'label' => 'Image grid 2 col (360 x 198)',
    'effects' => array(
      4 => array(
        'name' => 'image_scale_and_crop',
        'data' => array(
          'width' => 360,
          'height' => 198,
        ),
        'weight' => 1,
      ),
    ),
  );

  // Exported image style: image_popular_post__80_x_66_.
  $styles['image_popular_post__80_x_66_'] = array(
    'label' => 'Image popular post (80 x 66)',
    'effects' => array(
      3 => array(
        'name' => 'image_scale_and_crop',
        'data' => array(
          'width' => 80,
          'height' => 66,
        ),
        'weight' => 1,
      ),
    ),
  );

  // Exported image style: image_search_result__263_x_148_.
  $styles['image_search_result__263_x_148_'] = array(
    'label' => 'Image search result (263 x 148)',
    'effects' => array(
      5 => array(
        'name' => 'image_scale_and_crop',
        'data' => array(
          'width' => 263,
          'height' => 148,
        ),
        'weight' => 1,
      ),
    ),
  );

  return $styles;
}

/**
 * Implements hook_node_info().
 */
function md_blog_node_info() {
  $items = array(
    'blog' => array(
      'name' => t('Blog'),
      'base' => 'node_content',
      'description' => '',
      'has_title' => '1',
      'title_label' => t('Title'),
      'help' => '',
    ),
  );
  drupal_alter('node_info', $items);
  return $items;
}
