<?php

function page_results($terms)
{    
    //-- extrait les termes recherchés
    $terms = urldecode($terms);
    
    //-- change le titre :
    drupal_set_title('Résultats de recherche pour "<em>' . check_plain($terms) . '</em>"', PASS_THROUGH);
    
    //-- lance la recherche
    $results = searchTerms($terms);
    $numResults = count($results);
    
    /**
     *  Classification des résultats :
     */
    foreach($results as $res)
    {
        if (hasADTClonePrefix($res->type))
        {
            $activite = getActiviteByCloneType($res->type);
            $cat = 'Activités - ' . $activite->nom;
        }
        else if ($res->type == 'cat_100_nature' || $res->type == 'fiche_100_nature')
        {
            $cat = '100% Nature';
        }
        else if ($res->type == 'categorie_abcd_air' || $res->type == 'fiche_abcd_air')
        {
            $cat = 'Petites histoires';
        }
        else
        {
            $cat = 'Autres';
        }
        $res->cat = $cat;
    }
    
    /**
     *  Charge le formulaire de recherche :
     */
    require_once(drupal_get_path('module', 'custom_search') . '/pages/search.pages.inc');
    $searchForm = drupal_get_form('form_page_search');
    
    
    /**
     *  Affichage des résultats :
     */
    $output = '<div class="search-results">';
    $output .= '<p>' . $numResults . ' résultats</p>';
    $output .= render($searchForm);
    
    $output .= '<ul>';
    
    foreach($results as $res)
    {
        $output .= '<li class="search-result">';
        $output .= '<h4><a href="/' . drupal_get_path_alias('node/' . $res->nid) . '">' . $res->title . '</a></h4>';
        $output .= '<p><small>' . $res->cat . '</small></p>';
        $output .= '<p>' . $res->teaser . '</p>';
        //$output .= '<p><small>(poids : ' . $res->weight . ')</small></p>';
        $output .= '</li>';
    }
    
    $output .= '</ul></div>';
    
    
    
    /**
     * Classification des résultats :
     *
    $activites = array();
    $nature = array();
    $abcdair = array();
    $autres = array();
    
    foreach($rawResults as $result)
    {
        if (hasADTClonePrefix($type)){
            $type = getActiviteByCloneType($type)->nom;
            $activites[$type] = $typeResults;
        }
        else if ($type == 'cat_100_nature' || $type == 'fiche_100_nature'){
            $type = '100% Nature';
            $nature[$type] = $typeResults;
        }
        else if ($type == 'categorie_abcd_air' || $type == 'fiche_abcd_air'){
            $type = 'Petites histoires';
            $abcdair[$type] = $typeResults;
        }
        else{
            $autres[$type] = $typeResults;
        }
        
        $numResults += count($typeResults);
    }
    
    $sortedResults = array(
        'Activités' => $activites,
        '100% Nature' => $nature,
        'Petites histoires' => $abcdair,
        'Autres' => $autres,
    );
    
    
    /*
     *  Affichage des résultats :
     *
    $output .= '<div class="search-results">';
    $output .= '<p>' . $numResults . ' résultats</p>';
    
    foreach($sortedResults as $cat => $catResults)
    {
        if (empty($typeResults)) continue;
        
        $output .= '<ul>';
        $output .= '<h3>' . $title . '</h3>';
        
        foreach($catResults as $type => $results)
        {
            foreach($results as $res)
            {
                $output .= '<li class="search-result">';
                $output .= '<h4><a href="/' . drupal_get_path_alias('node/' . $res->nid) . '">' . $res->title . '</a></h4>';
                
                if ($cat == 'Activités')
                    $output .= '<p><small>' . $cat . ' - ' . $type . '</small></p>';
                else
                    $output .= '<p><small>' . $type . '</small></p>';
                
                $output .= '<p>' . $res->teaser . '</p>';
                //$output .= '<p><small>(poids : ' . $res->weight . ')</small></p>';
                $output .= '</li>';
            }
        }
        
        $output .= '</ul>';
    }
    
    $output .= '</div>';
    */
    
    return $output;
}


?>
