(function ($) {
$(window).ready(function() {
    'use strict';
    /* Google Maps */
    
    var iterator = 0;
    var map;


    /* FULL MAP */
    var google_maps_circle_color = '#319db5';
    var google_maps_landscape_color = '#3C3C3C';
    var google_maps_water_color = '#232323';

    map_height($('#full-map'));
    fullMap($('#full-map'));

    $(window).resize(function() {
        map_height($('#full-map'));
    });


    function map_height(maps) {
        maps.height('');
        var window_h = $(window).height();
        var html_h = $(document).height();
        maps.css({
            'height': window_h
        });
    }

    function fullMap(maps) {
        var $location           = maps.children('.md_map').attr('data-location');
        var $number_location    = $location.split(",");
        var $zoom               = parseInt(maps.children('.md_map').attr('data-zoom'));
        var $scrollwheel        = maps.children('.md_map').attr('data-type');
        var $typeScrollwheel    = true;
        if($scrollwheel == 'no'){
            $typeScrollwheel = false;
        }
        
        var myOptions = {
            zoom: $zoom,
            center: new google.maps.LatLng($number_location[0], $number_location[1]),
            navigationControlOptions: {
                style: google.maps.NavigationControlStyle.NORMAL,
                position: google.maps.ControlPosition.RIGHT_TOP
            },
            streetViewControl: false,
            scrollwheel: $typeScrollwheel,
            zoomControl: false,
            panControl: false,
            zoomControlOptions: {
                style: google.maps.ZoomControlStyle.DEFAULT,
                position: google.maps.ControlPosition.RIGHT_TOP
            },
            mapTypeControl: false,
            mapTypeControlOptions: {
                style: google.maps.MapTypeControlStyle.DROPDOWN_MENU,
                position: google.maps.ControlPosition.TOP_RIGHT,
                mapTypeIds: ["ptMap"]
            }
        };

        map = new google.maps.Map(document.getElementById('full-map'), myOptions);

        var mapStyle = [
            {
                featureType: "administrative",
                elementType: "all",
                stylers: [{
                    visibility: "off"
                }]
            },
            {
                featureType: 'landscape',
                elementType: 'all',
                stylers: [{
                    color: google_maps_landscape_color
                }, {
                    visibility: 'on'
                }]
            },
            {
                featureType: "poi",
                elementType: "all",
                stylers: [{
                    visibility: "off"
                }]
            },
            {
                featureType: "road",
                elementType: "all",
                stylers: [{
                    visibility: "on"
                }, {
                    lightness: -30
                }]
            },
            {
                featureType: "transit",
                elementType: "all",
                stylers: [{
                    visibility: "off"
                }]
            },
            {
                featureType: "water",
                elementType: "all",
                stylers: [{
                    color: google_maps_water_color
                }]
            }
          ];
        var styledMapOptions = {
            name: "Map"
        };
        var ptMapType = new google.maps.StyledMapType(mapStyle, styledMapOptions);
        map.mapTypes.set("ptMap", ptMapType);
        map.setMapTypeId("ptMap");
        var circle = {
            path: google.maps.SymbolPath.CIRCLE,
            fillOpacity: 0.6,
            fillColor: google_maps_circle_color,
            strokeWeight: 0,
            scale: 12
        };
        var markerFull = new MarkerWithLabel({
            position: map.getCenter(),
            icon: {
                path: google.maps.SymbolPath.CIRCLE,
                scale: 0
            },
            map: map,
            draggable: true,
            labelAnchor: new google.maps.Point(10, 10),
            labelClass: 'pulse-label'
        });
    }
});
})(jQuery);