/**
 * File: awecontent-divider-item.js
 * Author: AWEThemes
 * Website: http://awethemes.com/
 */
(function($) {
    "use strict";

    /**
     * Define model for heder item
     */
    AWEContent.Models.DividerItem = AWEContent.Models.Item.extend({
        defaults: {
            machine_name: "divider",

            textContent: 'Divider text here',
            borderStyle: 'dotted',
            borderColor: '#ccc',
            borderWeight: 0,
            widthDivider : 0,
            with: 'text',
            fontFamily: '',
            fontStyle: '',
            fontSize: -1,
            lineHeight: -1,
            letterSpacing: -1,
            color: '',
            contentBackground:'',
            contentHeight:30,
            contentWidth:200,
            contentBorder:{},
            nameIcon:'ic ac-icon-help',
            iconFontSize:-1,
            margin: {},
            customID: '',
            customClass: '',
            customEnableAttributes: 0,
            customDataAttributes: '[] ', // Array Json
            customActionAttributes: '{"newAction": "", "newAttrName": "", "newAttrValue": ""}',
            customEnableAnimations: 0,
            customDataAnimations: '{"type": "none"}', // Data Object
            lgResponsive: true,
            xsResponsive: true,
            mediumResponsive: true,
            smResponsive: true
        },
        createView: function() {
            this.view = new AWEContent.Views.DividerItem({model: this});
        },
        relations: [
            {
                type: Backbone.HasOne,
                key: "margin",
                relatedModel: AWEContent.Models.BoxModelSettings
            },
            {
                type: Backbone.HasOne,
                key: "contentBorder",
                relatedModel: AWEContent.Models.BoxModelSettings
            }
        ],
        clone : function(){
            var cloneModel = {};
            $.each(this.toJSON(), function(key,value){
                cloneModel[key] = value;
            });
            cloneModel.margin = new AWEContent.Models.BoxModelSettings(cloneModel.margin);
            return new AWEContent.Models.DividerItem(cloneModel);
        }
    });

    /**
     * Define View for HeaderItem
     */
    AWEContent.Views.DividerItem = AWEContent.Views.Item.extend({
        initialize: function() {
            AWEContent.Views.Item.prototype.initialize.call(this);
            this.listenTo(this.model.get("margin"), "change", this.applySettingsChanged);
            this.listenTo(this.model.get("contentBorder"), "change", this.applySettingsChangedBorder);
        },
        renderItemContent: function() {
            var self = this,
                $divider = $('<div class="obj-content awe-item awe-divider">\
                <div class="divider-field">\
                    <span class="divider-left"><span class="line-divider"></span></span>\
                    <span class="text-divider"><div class="content" contenteditable="true" ></div></span>\
                    <span class="divider-right"><span class="line-divider"></span></span>\
                </div>\
                </div>'),
                settings = self.model.toJSON(),
                $dividerLeft = $('.divider-left', $divider),
                $dividerRight = $('.divider-right', $divider),
                $dividerText = $('.text-divider .content', $divider),
                $dividerLine = $('.line-divider', $divider),
                $dividerContent = $('.text-divider', $divider);                

            self.iframeJQuery(this.el).delegate('.awe-divider', "itemReady", function() {
                var heightBefore, heightAfter;
                self.iframeJQuery('.text-divider .content', this).hallo({
                    plugins: {
                        "halloformat": {}
                    },
                    editable: true,
                    create : function(){
                        this.addEventListener("paste", function(e) {
                            e.preventDefault();
                            var text = e.clipboardData.getData("text/plain");
                            AWEContent.documentIframe.execCommand("insertHTML", false, text);

                        });
                    },
                    activated: function (event) {
                        heightBefore = $(event.target).height();
                    },
                    deactivated: function(event) {
                        self.changeContent(event);

                        heightAfter = $(event.target).height();
                        if (heightBefore != heightAfter) {
                            self.resizeItem();
                        }
                    }
                });
                // self.iframeJQuery('.text-divider', this).resizable({
                //     handles: "e",
                //     resize: function(event, ui) {
                //         var width = ui.size.width;
                //         self.model.set('width', width);
                //     },
                //     start: function (event, ui) {
                //         heightBefore = $(event.target).height();
                //     },
                //     stop : function (event,ui) {
                //         heightAfter = $(event.target).height();
                //         if (heightAfter != heightBefore) {
                //             self.resizeItem();
                //         }
                //     }
                // });
            });

            // process font style for element
            var css = {
                'font-size' : settings.fontSize == -1 ? '' : (settings.fontSize + 'px'),
                'line-height' : settings.lineHeight == -1 ? '' : (settings.lineHeight + 'px'),
                'letter-spacing' : settings.letterSpacing == -1 ? '' : (settings.letterSpacing + 'px')
            };
            if (settings.fontStyle)
                css = $.extend({}, css, JSON.parse(settings.fontStyle));
            $dividerText.html(settings.textContent).css(css).addClass(settings.fontFamily.replace(/ /g, ''));            
            
            if ( settings.with == 'none') {
                $dividerText.parent().hide();
                $dividerRight.hide();
            } else {
                $dividerContent.css({
                    'height' : settings.contentHeight == -1 ? '' : (settings.contentHeight + 'px'),
                    'width' : settings.contentWidth == -1 ? '' : (settings.contentWidth + 'px'),
                    'background' : settings.contentBackground,
                    'color' : settings.color,
                });
                $dividerContent.renderItemDefaultBoxModel(settings.contentBorder);
                switch(settings.with){
                    case 'text':
                        $dividerText.parent().removeClass('center-line-divider center-icon-divider');
                        break;
                    case 'line':
                        $dividerText.parent().addClass('center-line-divider').removeClass('center-icon-divider');
                        break;
                    case 'icon':
                        $dividerText.parent().addClass('center-icon-divider').removeClass('center-line-divider').append('<i class="' + settings.nameIcon + '"></i>');
                        $dividerContent.find('i').css({
                            'font-size' : settings.iconFontSize == -1 ? '' : (settings.iconFontSize + 'px'),
                            'line-height':settings.contentHeight > 0 ? (settings.contentHeight + 'px') : 1
                        });
                        break;
                }
            }
            $dividerLine.css({
                'border-top-style' : settings.borderStyle,
                'border-top-color': settings.borderColor,
                'border-top-width' : !settings.borderWeight ? '' : ( settings.borderWeight + 'px')
            });
            $divider.renderItemDefaultAttributes(settings.customEnableAttributes, settings.customDataAttributes);
            $divider.attr('id', settings.customID).addClass(settings.customClass).renderItemDefaultBoxModel(settings.margin);
            $divider.css('width', !settings.widthDivider ? '' : settings.widthDivider + 'px');
            if (settings.customEnableAnimations) {
                var animation = settings.customDataAnimations;
                $divider.processAnimations(animation)
            }
            self.$el.defaultResponsive(settings);
            return $divider;
        },
        changeContent : function(el) {
            var content = $(el.currentTarget).html();
            this.model.set('textContent', content);
        },
        applySettingsChanged: function(model) {
            var self = this,
                $divider = $('.awe-divider', self.el),
                $lineDivider = $('.line-divider', $divider),
                $textDivider = $('.text-divider .content', $divider),
                $dividerLeft = $('.divider-left', $divider),
                $dividerRight = $('.divider-right', $divider),
                settings = self.model.toJSON(),
                heightBefore = self.$el.height();
            var $parentTextDivider = $('.text-divider', $divider);

            $.each(model.changed, function(key, value) {
                self.$el.changeResponsive(key, value);
                $divider.renderChangeSettingBoxModel(key, value, model);
                switch (key) {
                    case 'borderStyle' :
                        $lineDivider.css('border-top-style', value);
                        break;

                    case 'borderColor' :
                        $lineDivider.css('border-top-color', value);
                        break;

                    case 'borderWeight' :
                        value == '0' ? $lineDivider.css('border-top-width', '') : $lineDivider.css('border-top-width', value + 'px');
                        break;

                    case 'widthDivider':
                        value == '0' ? $divider.css('width', '') : $divider.css('width', value + 'px');
                        break;

                    case 'with' :                        
                        if (value == 'none') {
                            $parentTextDivider.hide();
                            $dividerRight.hide();
                        }
                        else {
                            $parentTextDivider.show();
                            $dividerRight.show();
                        }
                        switch(value){
                            case 'text':
                                $parentTextDivider.removeClass('center-line-divider center-icon-divider');
                                break;
                            case 'line':
                                $parentTextDivider.addClass('center-line-divider').removeClass('center-icon-divider');
                                break;
                            case 'icon':
                                $parentTextDivider.addClass('center-icon-divider').removeClass('center-line-divider');
                                if(!$parentTextDivider.find('i').length){
                                    $parentTextDivider.append('<i class="' + settings.nameIcon + '"></i>');
                                    $parentTextDivider.find('i').css({'font-size' : value+'px', 'line-height': settings.contentHeight > 0 ? (settings.contentHeight + 'px') : 1});
                                }
                                break;
                        }                        
                        break;
                    case 'contentBackground':
                        $parentTextDivider.css('background',value);
                        break;
                    case 'contentHeight':
                        $parentTextDivider.height(value);
                        if(settings.with == 'icon')
                            $parentTextDivider.find('i').css('line-height', value + 'px');
                        break;
                    case 'contentWidth':
                        $parentTextDivider.width(value);
                        break;
                    case 'iconFontSize':
                        $parentTextDivider.find('i').css('font-size',value+'px');
                        break;
                    case 'nameIcon' :
                        var prevIcon = self.model.previousAttributes().nameIcon;
                        $parentTextDivider.find('i').removeClass(prevIcon).addClass(value);
                        break;
                    case 'fontFamily':
                        var prevFamily = self.model.previousAttributes().fontFamily.replace(/ /g, ''),
                            currentFamily = value.replace(/ /g, '');
                        $textDivider.removeClass(prevFamily).addClass(currentFamily);
                        break;

                    case 'fontStyle':
                        var fontStyle = (value) ? JSON.parse(value) : {'font-weight': '', 'font-style': ''};
                        $textDivider.css(fontStyle);
                        break;

                    case 'fontSize' :
                        value == -1 ? $textDivider.css('font-size', '') : $textDivider.css('font-size', value + 'px');
                        break;

                    case 'lineHeight' :
                        value == -1 ? $textDivider.css('line-height', '') : $textDivider.css('line-height', value + 'px');
                        break;

                    case 'letterSpacing':
                        value == -1 ? $textDivider.css('letter-spacing','') : $textDivider.css('letter-spacing', value + 'px');
                        break;

                    case 'color' :
                        $parentTextDivider.css('color', value);
                        break;

                    case 'customID' :
                        $divider.attr('id', value);
                        break;

                    case 'customClass':
                        var prevClass = self.model.previousAttributes().customClass;
                        $divider.removeClass(prevClass).addClass(value);
                        break;

                    case 'customEnableAttributes':
                        $divider.renderChangeSettingsAttributes(key, value, settings.customDataAttributes);
                        break;

                    case 'customActionAttributes':
                        $divider.renderChangeSettingsAttributes(key, value);
                        break;

                    case 'customEnableAnimations':
                        var animation, prevAnimation;
                        if (value) {
                            animation = settings.customDataAnimations;
                            prevAnimation = null;
                            $divider.processAnimations(animation);
                        }
                        else {
                            animation = null;
                            prevAnimation = settings.customDataAnimations;
                            $divider.processAnimations(animation, prevAnimation);
                        }

                        break;
                    case 'customDataAnimations':
                        var animation, prevAnimation;
                        animation = settings.customDataAnimations;
                        prevAnimation = self.model.previousAttributes().customDataAnimations;
                        $divider.processAnimations(animation, prevAnimation);
                        break;
                }
            });

            // Listen event change height of item
            setTimeout(function() {
                self.checkChangeHeight(heightBefore);
            }, 50);
        },
        applySettingsChangedBorder: function(model){
            var self = this;
            $.each(model.changed, function(key, value) {
                $('.text-divider', self.el).renderChangeSettingBoxModel(key, value, model);
            });
        }
    });

    /**
     * Define view for Header Controller
     * li tag what is contained by items panel
     */
    AWEContent.Views.DividerItemController = AWEContent.Views.ItemController.extend({
        machineName : 'divider',
        controllerHtml: function() {
            return '<div class="title-icon">Divider</div><i class="ic ac-icon-divider"></i>';
        },
        createItemModel: function(templateData) {
            var margin;
            if (templateData!= undefined) {

                margin = new AWEContent.Models.BoxModelSettings(templateData.margin);
                templateData.boxModelSettings = margin;

                return new AWEContent.Models.DividerItem(templateData);
            }

            return new AWEContent.Models.DividerItem({'margin' : new AWEContent.Models.BoxModelSettings()});
        }
    });
    /**
     * Define header panel
     */
    AWEContent.Views.DividerPanel = AWEContent.Views.ItemPanel.extend({
        tagName: "div",
        className: "awe-obj-panel panel-divider",
        panelName: "divider",
        initPanel: function() {
            AWEContent.Views.ItemPanel.prototype.initPanel.call(this);
            var self = this;

            $('#divider-style', this.el).change( function(event, values) {
                self.editingModel.set('borderStyle', values.value);
            });
            $('#divider-color', this.el).change(function(event, color) {
                if (color)
                    color = color.toRgbString();
                else
                    color = '';
                self.editingModel.set('borderColor', color);
            });
            $('#divider-height', this.el).change(function(event, values) {
                self.editingModel.set('borderWeight', values.value);
            });
            $('#divider-width', self.el).change( function(event, values) {
                    self.editingModel.set('widthDivider', values.value);
            });
            $('#divider-with', this.el).change( function(event, values) {
                if (values.value == 'none')
                    $('#divider-font, #divider-color-element', self.$el).hide()
                else
                    $('#divider-font, #divider-color-element', self.$el).show();

                self.editingModel.set('with', values.value);
                self.showHideSettings(values.value);
            });
            
             $('#custom-choose-icons .title-tab', self.el).click( function() {
                var $controller = $(this).closest('#custom-choose-icons');
                AWEContent.Panels.listIconPanel.processIcon($controller);
            });
            $('#custom-choose-icons', self.el).change( function(event, data) {
                if (data) {
                    self.editingModel.set('nameIcon', data.nameIcon);
                    $('.title-tab > i', this).removeClass().addClass(data.nameIcon);
                }
            });
            $('#divider-custom-size', self.el).change(function(event, values) {
                self.editingModel.set('iconFontSize', values.value);
                if (values.value == -1)
                    $('.display-font', $(this)).text('DF');
            });
            $('#divider-content-background', this.el).change(function(event, color) {
                if (color)
                    color = color.toRgbString();
                else
                    color = '';
                self.editingModel.set('contentBackground', color);
            });
            $('#divider-content-height', this.el).change(function(event, values) {
                self.editingModel.set('contentHeight', values.value);
            });
            $('#divider-content-width', this.el).change(function(event, values) {
                self.editingModel.set('contentWidth', values.value);
            });
            $('#divider-content-border', self.el).initBoxModelPanel(self, 'contentBorder');

            $('#divider-font', this.$el).bind('fontFamilyChange', function(event, param) {
                self.editingModel.set('fontFamily', param);
            }).bind('fontStyleChange', function(event, fontStyle) {
                self.editingModel.set('fontStyle', fontStyle.value);
            }).bind('fontSizeChange', function(event, fontSize) {
                self.editingModel.set('fontSize', fontSize.value);
            }).bind('letterSpacingChange', function(event, letterSpacing) {
                self.editingModel.set('letterSpacing', letterSpacing.value);
            }).bind('lineHeightChange', function(event, lineHeight) {
                self.editingModel.set('lineHeight', lineHeight.value);
            });

            $('#divider-color-element', self.el).change(function(event, color) {
                if (color)
                    color = color.toRgbString();
                else
                    color = '';
                self.editingModel.set('color', color);
            });
            $('#divider-column-box-model', self.el).initBoxModelPanel(self, 'margin');
            $('#text-divider-custom-id', self.el).change( function() {
                self.editingModel.set('customID', $(this).val());
            });
            $('#text-divider-custom-class', self.el).change( function() {
                self.editingModel.set('customClass', $(this).val());
            });
            $('#divider-custom-attributes', this.el).initAttributesPanel(self);
            $('#divider-animations', this.el).change(function(event, data) {
                self.editingModel.set('customEnableAnimations', data.enabled);
                if (data){
                    self.editingModel.set('customDataAnimations', data.animations);
                }
            });
        },
        setPanelElementsValue: function() {
            var settings = this.editingModel.toJSON();
            $('#divider-style', this.$el).aweSelect('value', settings.borderStyle);
            $('#divider-color', this.$el).aweColorPicker('value', settings.borderColor);
            $('#divider-height', this.$el).aweSlider('value', settings.borderWeight);
            $('#divider-width', this.$el).aweSlider('value', settings.widthDivider);
            $('#divider-with', this.el).aweSelect('value', settings.with);
            $('#divider-content-background', this.$el).aweColorPicker('value', settings.contentBackground);
            $('#divider-content-height', this.$el).aweSlider('value', settings.contentHeight);
            $('#divider-content-width', this.$el).aweSlider('value', settings.contentWidth);
            $('#divider-content-border', this.$el).initBoxModel(settings.contentBorder);
            $('#custom-choose-icons', this.el).attr('data-name-icon', settings.nameIcon);
            $('#custom-choose-icons i', this.el).removeClass().addClass(settings.nameIcon);
            $('#divider-custom-size', this.el).aweSlider('value', settings.iconFontSize);
            
            this.showHideSettings(settings.with);
            $('#divider-font', this.$el).aweFont('options', {
                fontFamily: settings.fontFamily,
                fontStyle: settings.fontStyle,
                fontSize: settings.fontSize,
                lineHeight: settings.lineHeight,
                letterSpacing: settings.letterSpacing
            });
            $('#divider-color-element', this.$el).aweColorPicker('value', settings.color);
            $('#divider-column-box-model', this.$el).initBoxModel(settings.margin);
            $('#text-divider-custom-id', this.el).val( settings.customID);
            $('#text-divider-custom-class', this.el).val( settings.customClass);
            $('#divider-custom-attributes', this.el).initAttributes(settings.customEnableAttributes, settings.customDataAttributes);
            $('#divider-animations', this.el).aweAnimation('value', {
                enabled: settings.customEnableAnimations,
                animations: settings.customDataAnimations,
                previewEl: this.editingModel.view.$el
            });
        },
        showHideSettings: function(content_type){
            if(!content_type)
                content_type = this.editingModel.get('with');
            if(content_type == 'none'){
                $('#divider-content-width', this.el).hide();
                $('#divider-content-border', this.el).hide();
                $('#divider-content-background', this.el).hide();
                $('#divider-content-height', this.el).hide();
            }else {
                $('#divider-content-background', this.el).show();
                $('#divider-content-height', this.el).show();
                $('#divider-content-width', this.el).show();
                $('#divider-content-border', this.el).show();
            }
            if(content_type != 'text'){
                $('#divider-font').hide();
            }
            if(content_type == 'icon'){
                $('#custom-choose-icons', this.el).show();
                $('#divider-custom-size', this.el).show();    
            }
            else{
                $('#custom-choose-icons', this.el).hide();
                $('#divider-custom-size', this.el).hide();
            }
            if($.inArray(content_type,['icon','text']) >= 0){
                $('#divider-color-element', this.el).show();
            } else {
                $('#divider-color-element', this.el).hide();
            }
        },
        buildPanel: function() {
            return {
                "title": {
                    "type": "markup",
                    "markup": "<div class=\"awe-title\"><h2>Divider<\/h2><\/div>"
                },
                "custom_style": {
                    "type": "section",
                    "style": {
                        "type": "select",
                        "title": "Style",
                        "options": {
                            "solid": "Solid",
                            "dotted": "Dotter",
                            "dashed": "Dashed"
                        },
                        "default_value": "solid"
                    },
                    "color": {
                        "type": "colorpicker",
                        "title": "Color",
                        "options": {
                            "preferredFormat"  : "rgb",
                            "AlphaVerticle"  : true,
                            "showAlpha"  : true,
                            "allowEmpty" : true,
                            "showInput" : true
                        }
                    },
                    "height": {
                        "type": "slider",
                        "title": "Height",
                        "min_value": 0,
                        "max_value": 100,
                        "default_value": 12,
                        "allow_type": true,
                        "unit": "px"
                    },
                    "width": {
                        "type": "slider",
                        "title": "Width",
                        "min_value": 0,
                        "max_value": 1000,
                        "default_value": 12,
                        "allow_type": true,
                        "unit": "px"
                    }
                },
                "custom_element": {
                    "type": "section",
                    "with": {
                        "type": "select",
                        "title": "With",
                        "options": {
                            'none' : 'None',
                            "text" : "Text",
                            "line" : "Line",
                            "icon" : 'Icon'
                        },
                        "default_value": "text"
                    },
                    "custom_choose_icons": {
                        "type": "tabs_icon",
                        "title": "<div class=\"title-tab\"><span>Choose Icons<\/span><i class=\"\"><\/i><\/div>",
                        "tabs": []
                    },
                    "custom_size": {
                        "type": "slider",
                        "title": "Font Size Icon",
                        "min_value": -1,
                        "unit": "px",
                        "max_value": 100,
                        "default_value": 100,
                        "allow_type": true
                    },
                    "color_element": {
                        "type": "colorpicker",
                        "title": "Color",
                        "options": {
                            "preferredFormat"  : "rgb",
                            "AlphaVerticle"  : true,
                            "showAlpha"  : true,
                            "allowEmpty" : true,
                            "showInput" : true
                        }
                    },
                    "content_background": {
                        "type": "colorpicker",
                        "title": "Content Background",
                        "options": {
                            "preferredFormat"  : "rgb",
                            "AlphaVerticle"  : true,
                            "showAlpha"  : true,
                            "allowEmpty" : true,
                            "showInput" : true
                        }
                    },
                    "content_height": {
                        "type": "slider",
                        "title": "Content height",
                        "min_value": 0,
                        "max_value": 100,
                        "default_value": 10,
                        "allow_type": true,
                        "unit": "px"
                    },
                    "content_width": {
                        "type": "slider",
                        "title": "Content width",
                        "min_value": 0,
                        "max_value": 600,
                        "default_value": 200,
                        "allow_type": true,
                        "unit": "px"
                    },
                    "content_border": {
                        "type": "tabs",
                        "tabs": [{
                          "tab_title": "Content Border",
                          "contents": {
                            "custom_border": {
                              "type": "box_border",
                              "min_value": 0,
                              "max_value": 100,
                              "default_value": 0
                            }
                          }
                        }]
                    },
                    "font": {
                        "type": "font",
                        disabledElements: ['textAlign']
                    }
                },
                "custom_box_model": {
                    "type": "section",
                    "column_box_model": {
                        "type": "tabs",
                        "tabs": [{
                            "tab_title": "Margin",
                            "contents": {
                                "custom_margin": {
                                    "type": "box_model",
                                    "model_type": "margin",
                                    'allow_type' : true,
                                    "min_value": 0,
                                    "max_value": 100,
                                    "default_value": 0
                                }
                            }
                        }]
                    }
                },
                "custom_definitions": {
                    "type": "section",
                    "custom_id": {
                        "type": "text_field",
                        "title": "ID",
                        "attributes": {
                            "placeholder": "wrapper"
                        },
                        "default_value": ""
                    },
                    "custom_class": {
                        "type": "text_field",
                        "title": "CSS class",
                        "attributes": {
                            "placeholder": "wrapper"
                        },
                        "default_value": ""
                    },
                    "custom_attributes": {
                        "type": "custom_attributes"
                    },
                    animations: {
                        type: "animations"
                    }
                }
            };
        }
    });

    $(document).ready(function() {
        AWEContent.Controllers.divider = new AWEContent.Views.DividerItemController();
        AWEContent.Panels.divider = new AWEContent.Views.DividerPanel();
    });
})(jQuery);
