(function($) {

    function portfolioIsotope() {
        if ($('.portfolioContainer').length) {
            var $container = $('.portfolioContainer');
            $container.isotope();
            $('.portfolioFilter a').click(function () {
                $('.portfolioFilter .current').removeClass('current');
                $(this).addClass('current');
                var selector = $(this).attr('data-filter');
                $container.isotope({
                    filter: selector,
                    transitionDuration: "0.6s",
                    masonryHorizontal: {
                        rowHeight: 360
                    }
                });
                return false;
            });
        }
    }


    $(document).ready(function() {

	      if ($.fn.appear) {
	          $('.animated').appear({force_process: true});
	      }

	      $('.animated').on('appear', function (event, $all_appeared_elements) {
	          var element = $(this),
	                  animation = element.data('animation'),
	                  animationDelay = element.data('animation-delay');
	          if (animationDelay) {
	              setTimeout(function () {
	                  element.addClass(animation + " visible");
	              }, animationDelay);
	          } else {
	              element.addClass(animation + " visible");
	          }
	      });


        /* Testimonial Slider */
        if ($('.testimonials-slider').length) {
            $('.testimonials-slider').bxSlider({
                pagerCustom: '#testimonials-pager',
                pager: true,
                touchEnabled: true,
                controls: false
            });
        }

				/* Image Carousel */
        $('[data-plugin-carousel]:not(.manual), .owl-carousel:not(.manual)').each(function () {
            var $this = $(this), opts = null,
                    pluginOptions = $this.data('plugin-options'),
                    defaults = {
                        "autoPlay": 3000,
                        "items": 1,
                        "singleItem": true,
                        "itemsDesktop": [1199, 5],
                        "itemsDesktopSmall": [980, 4],
                        "itemsTablet": [768, 3],
                        "itemsMobile": [479, 2],
                    };
            opts = $.extend({}, defaults, pluginOptions);
            $this.owlCarousel(opts);
        });

	    	/* Portfolio Isotope */
	      portfolioIsotope();

		    $(window).resize(function () {
		        portfolioIsotope();
		    });

		});
		
})(jQuery);