<?php
	global $base_url;

	function utcdate() {
		return gmdate("Y-m-d\Th:i:s\Z");
	}

	function KmlToGpx($u, $url = null){
		/*$u_parts = pathinfo($u); //array of url parts
		$u_ext = strtoupper($u_parts['extension']);*/
		//if ($u_ext== "kml") {

			$dom_kml = new DOMDocument();
			$dom_kml->loadXML($u);

			$dom_gpx = new DOMDocument('1.0', 'UTF-8');
			$dom_gpx->formatOutput = true;
			
			//root node
			$gpx = $dom_gpx->createElement('gpx');
			$gpx = $dom_gpx->appendChild($gpx);
			
			$gpx_version = $dom_gpx->createAttribute('version');
			$gpx->appendChild($gpx_version);
			$gpx_version_text = $dom_gpx->createTextNode('1.0');
			$gpx_version->appendChild($gpx_version_text);
			
			$gpx_creator = $dom_gpx->createAttribute('creator');
			$gpx->appendChild($gpx_creator);
			$gpx_creator_text = $dom_gpx->createTextNode('http://thydzik.com');
			$gpx_creator->appendChild($gpx_creator_text);
			
			$gpx_xmlns_xsi = $dom_gpx->createAttribute('xmlns:xsi');
			$gpx->appendChild($gpx_xmlns_xsi);
			$gpx_xmlns_xsi_text = $dom_gpx->createTextNode('http://www.w3.org/2001/XMLSchema-instance');
			$gpx_xmlns_xsi->appendChild($gpx_xmlns_xsi_text);
			
			$gpx_xmlns = $dom_gpx->createAttribute('xmlns');
			$gpx->appendChild($gpx_xmlns);
			$gpx_xmlns_text = $dom_gpx->createTextNode('http://www.topografix.com/GPX/1/0');
			$gpx_xmlns->appendChild($gpx_xmlns_text);
			
			$gpx_xsi_schemaLocation = $dom_gpx->createAttribute('xsi:schemaLocation');
			$gpx->appendChild($gpx_xsi_schemaLocation);
			$gpx_xsi_schemaLocation_text = $dom_gpx->createTextNode('http://www.topografix.com/GPX/1/0 http://www.topografix.com/GPX/1/0/gpx.xsd');
			$gpx_xsi_schemaLocation->appendChild($gpx_xsi_schemaLocation_text);
			
			$gpx_url = $dom_gpx->createElement('url');
			$gpx_url = $gpx->appendChild($gpx_url);
			$gpx_url_text = $dom_gpx->createTextNode($url);
			$gpx_url->appendChild($gpx_url_text);
			
			$gpx_time = $dom_gpx->createElement('time');
			$gpx_time = $gpx->appendChild($gpx_time);
			$gpx_time_text = $dom_gpx->createTextNode(utcdate());
			$gpx_time->appendChild($gpx_time_text);
			
			// placemarks
			$names = array();
			foreach ($dom_kml->getElementsByTagName('Placemark') as $placemark) {
				//name
				foreach ($placemark->getElementsByTagName('name') as $name) {
					$name  = $name->nodeValue;
					//check if the key exists
					if (array_key_exists($name, $names)) {
						//increment the value
						++$names[$name];
						$name = $name." ({$names[$name]})";
					} else {
						$names[$name] = 0;
					}
				}
				//description
				foreach ($placemark->getElementsByTagName('description') as $description) {
					$description  = $description->nodeValue;
				}
				foreach ($placemark->getElementsByTagName('Point') as $point) {
					foreach ($point->getElementsByTagName('coordinates') as $coordinates) {
						//add the marker
						$coordinate = $coordinates->nodeValue;
						$coordinate = str_replace(" ", "", $coordinate);//trim white space
						$latlng = explode(",", $coordinate);
						
						if (($lat = $latlng[1]) && ($lng = $latlng[0])) {
							$gpx_wpt = $dom_gpx->createElement('wpt');
							$gpx_wpt = $gpx->appendChild($gpx_wpt);

							$gpx_wpt_lat = $dom_gpx->createAttribute('lat');
							$gpx_wpt->appendChild($gpx_wpt_lat);
							$gpx_wpt_lat_text = $dom_gpx->createTextNode($lat);
							$gpx_wpt_lat->appendChild($gpx_wpt_lat_text);
							
							$gpx_wpt_lon = $dom_gpx->createAttribute('lon');
							$gpx_wpt->appendChild($gpx_wpt_lon);
							$gpx_wpt_lon_text = $dom_gpx->createTextNode($lng);
							$gpx_wpt_lon->appendChild($gpx_wpt_lon_text);
							
							$gpx_time = $dom_gpx->createElement('time');
							$gpx_time = $gpx_wpt->appendChild($gpx_time);
							$gpx_time_text = $dom_gpx->createTextNode(utcdate());
							$gpx_time->appendChild($gpx_time_text);
							
							$gpx_name = $dom_gpx->createElement('name');
							$gpx_name = $gpx_wpt->appendChild($gpx_name);
							// $gpx_name_text = $dom_gpx->createTextNode($name);
							// $gpx_name->appendChild($gpx_name_text);
							
							$gpx_desc = $dom_gpx->createElement('desc');
							$gpx_desc = $gpx_wpt->appendChild($gpx_desc);
							$gpx_desc_text = $dom_gpx->createTextNode($description);
							$gpx_desc->appendChild($gpx_desc_text);
							
							//$gpx_url = $dom_gpx->createElement('url');
							//$gpx_url = $gpx_wpt->appendChild($gpx_url);
							//$gpx_url_text = $dom_gpx->createTextNode($ref);
							//$gpx_url->appendChild($gpx_url_text);
							
							$gpx_sym = $dom_gpx->createElement('sym');
							$gpx_sym = $gpx_wpt->appendChild($gpx_sym);
							$gpx_sym_text = $dom_gpx->createTextNode('Waypoint');
							$gpx_sym->appendChild($gpx_sym_text);
						}
					}
				}
				foreach ($placemark->getElementsByTagName('LineString') as $lineString) {
					foreach ($lineString->getElementsByTagName('coordinates') as $coordinates) {
						//add the new track
						$gpx_trk = $dom_gpx->createElement('trk');
						$gpx_trk = $gpx->appendChild($gpx_trk);
						
						$gpx_name = $dom_gpx->createElement('name');
						$gpx_name = $gpx_trk->appendChild($gpx_name);
						$gpx_name_text = $dom_gpx->createTextNode($name);
						$gpx_name->appendChild($gpx_name_text);
						
						$gpx_trkseg = $dom_gpx->createElement('trkseg');
						$gpx_trkseg = $gpx_trk->appendChild($gpx_trkseg);
					
						$coordinates = $coordinates->nodeValue;
						$coordinates = preg_split("/[\s\r\n]+/", $coordinates); //split the coords by new line
						foreach ($coordinates as $coordinate) {
							$latlng = explode(",", $coordinate);
							if(count($latlng) > 1 ){
								if (($lat = $latlng["1"]) && ($lng = $latlng["0"])) {
									$gpx_trkpt = $dom_gpx->createElement('trkpt');
									$gpx_trkpt = $gpx_trkseg->appendChild($gpx_trkpt);

									$gpx_trkpt_lat = $dom_gpx->createAttribute('lat');
									$gpx_trkpt->appendChild($gpx_trkpt_lat);
									$gpx_trkpt_lat_text = $dom_gpx->createTextNode($lat);
									$gpx_trkpt_lat->appendChild($gpx_trkpt_lat_text);
									
									$gpx_trkpt_lon = $dom_gpx->createAttribute('lon');
									$gpx_trkpt->appendChild($gpx_trkpt_lon);
									$gpx_trkpt_lon_text = $dom_gpx->createTextNode($lng);
									$gpx_trkpt_lon->appendChild($gpx_trkpt_lon_text);
									
									$gpx_time = $dom_gpx->createElement('time');
									$gpx_time = $gpx_trkpt->appendChild($gpx_time);
									$gpx_time_text = $dom_gpx->createTextNode(utcdate());
									$gpx_time->appendChild($gpx_time_text);
								}
							}
						}
					}
				}
			//}
			return $dom_gpx->saveXML();
		}
	}

	function getFicheType($adt_id){
		$prefix = substr($adt_id,0,3);
		switch($prefix){
			case 'FMA';
				//agenda
				return array('type' => 'agenda', 'slug' => 'agenda/') ;
			break;
			case 'GUI';
				//prestataires
				return array('type' => 'presta', 'slug' => '') ;
			break;
			default:
				//Autre dont fiche rando 
				return array('type' => 'activite', 'slug' => '') ;
			break;
		}
	}

	function getFicheUrl($nid, $adt_id, $title){
		require_once('sites/all/libraries/Inflector.php');
		if(is_null($nid)){
			$title = strtolower(strip_tags($title));
			$typefiche = getFicheType($adt_id);
			return $typefiche['slug'].Inflector::slug($title, $replacement = '-').'_'.$adt_id.'_fiche.html';
		}else{
			return drupal_lookup_path('alias',"node/".$nid);
		}
	}

	function getFicheTitle($xmlObj = null){
		if (is_null($xmlObj)) return;
		foreach ($xmlObj->xpath('societe') as $result) return $result;
	}
	
	/* Extraction des photos */
	function getIllustrPhoto($xmlObj, $adt_id=null){

		$typefiche = getFicheType($adt_id);


		$path = 'obj_common/photo/ass_obj_photo/doctype[. ="Photo"]/following-sibling::type_descriptif[. ="TECHN"]/following-sibling::fic_m';
		$photos = $xmlObj->xpath($path); 

		if(!$photos){
			$path = 'obj_common/photo/ass_obj_photo[doctype="Photo" and docsstype!="Accroche"]/fic_m';
			$photos = $xmlObj->xpath($path);
		}

		$photo = array();
		if($photos) {
			while(list( , $node) = each($photos)) {
			     $photo[] = $node;
			}
		}
		$img_illustr = count($photo) > 0 ? variable_get('adt_pictures_path') . $photo[0] : '/sites/default/files/no-image.jpg';
		return $img_illustr;
	}

	function getTxtDesc($xmlObj){
		/* Texte  */
		$txt = array();

			$txts =  $xmlObj->xpath('obj_common/siteaff_desc/ass_obj_siteaff_desc/type_descriptif[. ="TECHN"]/preceding-sibling::descriptif_spec');
		if(!$txts){
			$txts =  $xmlObj->xpath('descriptif_fr');
		}elseif(!$txts){
			$txts =  $xmlObj->xpath('obj_common/siteaff_desc/ass_obj_siteaff_desc/type_descriptif[. ="NATUR"]/preceding-sibling::descriptif_spec');
		}

		while(list( , $node) = each($txts)) {
			     $txt[] = $node;
			}

		if(!empty($txt)){
			$string = str_replace(array('\r\n', '\r', '\n'), '', $txt[0]);
			return $string;
		}
		else{
			return '';}
	}


	function getFichePdf($xmlObj, $adt_id = null){
		/* Extraction des Pdf */
		$pdfs = $xmlObj->xpath('obj_common/photo/ass_obj_photo/doctype[. ="PDF"]/following-sibling::type_descriptif[. ="TECHN"]/following-sibling::fic_o'); 
		$pdf = array();
		if($pdfs) {
			while(list( , $node) = each($pdfs)) {
			     $pdf[] = $node;
			}
		}
		$pdf = count($pdf) > 0 ? variable_get('adt_pictures_path') .$pdf[0] : BASEURL.'/carnet/printpdf/'.$adt_id;
		return $pdf;
	}

	function getKml($xmlObj){
		$kml = array();
		$kmls =  $xmlObj->xpath('obj_common/id');
		if($kmls){
			while(list( , $node) = each($kmls)) {
			     $kml[] = $node;
			}
			return $kml[0];
		}else{
			return '';
		}
	}

	function ficheAdtToPdf($adt_id, $mode='D'){

		$rawXML = getItemData($adt_id);

	    $xml = new DOMDocument();
	    $xml->loadXML($rawXML);
	    
	    $proc = new XSLTProcessor();
	    
	    $type=substr($adt_id, 0, 3);
	    
	    $xsl = new DOMDocument();
	    $xsl->load(variable_get('url_xslt_pdf').$type);
	    
	    $proc->importStyleSheet($xsl); 

		

		$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		// set document information
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor('Cote d\'or Tourisme');
		$pdf->SetTitle('Mon carnet de Voyage');
		$pdf->SetSubject('Mon carnet de Voyage');
		$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

		// set default header data
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 021', PDF_HEADER_STRING);

		// set header and footer fonts
		$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
		$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

		// set default monospaced font
		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

		//set margins
		$pdf->SetMargins(PDF_MARGIN_LEFT, 40, PDF_MARGIN_RIGHT);
		$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

		//set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

		//set image scale factor
		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

		//set some language-dependent strings
		global $l;
		$pdf->setLanguageArray($l);

		// ---------------------------------------------------------

		// set font
		$pdf->SetFont('helvetica', '', 9);

		// add a page
		$pdf->AddPage();	

		$html = '<style>
					#fiche_objet p {
						margin: 0 0 0.5em;
					}
					#fiche_objet h1 {
						margin-bottom: 2px;
						font-size: 1.8em;
						line-height: 1.4;
					}

					#fiche_objet li {
					    background-image:url(https://www.cotedor-tourisme.com/pics/01/puce.gif);
						background-repeat:no-repeat;
						background-position:left 6px;
						padding-left:10px;
						width:auto;
						display:inline;
						margin-left: 8px;
					}
					#fiche_objet a[href $=\'.pdf\'] {
					   padding-right: 18px;
					   background: transparent url(../images/icon_pdf.gif) no-repeat center right;
					}
					.ad-image-wrapper, .ad-controls{
						display : none;
					}
					.ad-thumb-list{list-style-type : none}
					.ad-thumb-list li{display : inline}
				</style>';

		$html .= $proc->transformToXML($xml);

		// echo $html;

		$pdf->writeHTML($html, true, 0, true, 0);

		$pdf->lastPage();

		// ---------------------------------------------------------

		//Close and output PDF document
		$mode = (is_null($mode) OR !in_array($mode, array('I', 'D', 'F', 'S'))) ? 'D' : $mode;
		// I: send the file inline to the browser. The plug-in is used if available. The name given by name is used when one selects the "Save as" option on the link generating the PDF.
		// D: send to the browser and force a file download with the name given by name.
		// F: save to a local file with the name given by name (may include a path).
		// S: return the document as a string. name is ignored.
		$folder = ($mode == 'D' OR $mode == 'I') ? '' : 'sites/default/files/tmp_pdf/';
		$pdf->Output($folder.$adt_id.'.pdf', $mode);
	}

?>