﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:php="http://php.net/xsl">
<xsl:template name="strip-tags">
	<xsl:param name="descriptif" select="objs/obj/descriptif_fr"/>
	<xsl:choose>
		<xsl:when test="contains($descriptif, '&lt;')">
			<xsl:value-of select="substring-before($descriptif, '&lt;')"/>
			<xsl:call-template name="strip-tags">
				<xsl:with-param name="descriptif" select="substring-after($descriptif, '&gt;')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$descriptif"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

 <xsl:variable name="_crlf"><xsl:text>
</xsl:text></xsl:variable>
  <xsl:variable name="crlf" select="string($_crlf)"/>

  <xsl:template name="crlf-replace">
    <xsl:param name="subject"/>

    <xsl:choose>
      <xsl:when test="contains($subject, $crlf)">
    <xsl:value-of select="substring-before($subject, $crlf)"/><br/>
    <xsl:call-template name="crlf-replace">
      <xsl:with-param name="subject" select="substring-after($subject, $crlf)"/>
    </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
    <xsl:value-of select="$subject"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

<xsl:template match="/">


<xsl:variable name="imagecache">
<xsl:for-each select="objs/obj/obj_common/photo/ass_obj_photo[doctype='Photo']">							
	<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_f)"/>|
</xsl:for-each>
<xsl:for-each select="/objs/obj/obj_common/ass_all[tbl='ass_hot_chaine']|/objs/obj/obj_common/ass_all[tbl='ass_label']">
	<xsl:if test="src_img!=''">
					<xsl:value-of select="src_img"/> :
	</xsl:if>
</xsl:for-each>
</xsl:variable>

	<div id="listezone">
	
<select name='zone' data-mini="true">
<option value="" class="sel_zone">Zone touristique</option>
<xsl:for-each select="/zones/ws_zone">

					<xsl:variable name="codeval">
						<xsl:value-of select="id_zone" />
						</xsl:variable >

						<xsl:variable name="codechk">
							<xsl:value-of select="php:function('isSelected',$codeval,'zone')"/>
						</xsl:variable >
					<option value="{$codeval}" class="sel_zone">
				
						
						
					
					
						<xsl:if test="$codechk!=''">
						<xsl:attribute name="{$codechk}"></xsl:attribute>
						</xsl:if>
					<xsl:value-of select="zone" /> (<xsl:value-of select="nb_occurs" />)

					
	
					</option>

	
</xsl:for-each>
</select>
</div>

	
	

</xsl:template>
</xsl:stylesheet>
