﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:php="http://php.net/xsl">
<xsl:output method="html" version="4.0" />
<xsl:template name="coupe">
	<xsl:param name="s" />
	<xsl:if test="contains($s,' ')">
		<xsl:variable name="s2">
			<xsl:call-template name="coupe">
				<xsl:with-param name="s" select="substring-after($s,' ')"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:value-of select="concat(substring-before($s,' '),' ',$s2)"/>
	</xsl:if>
</xsl:template>
<xsl:template name="removeHtmlTags">
    <xsl:param name="html"/>
    <xsl:choose>
      <xsl:when test="contains($html, '&lt;')">
        <xsl:value-of select="substring-before($html, '&lt;')"/>
        <!-- Recurse through HTML -->
        <xsl:call-template name="removeHtmlTags">
          <xsl:with-param name="html" select="substring-after($html, '&gt;')"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$html"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


<xsl:template match="/">


	
	<div class="swiper-container">
		<div class="swiper-wrapper">
			<xsl:for-each select="objs/obj">
				<xsl:variable name="id">
					<xsl:value-of select="id"/>
				</xsl:variable>
	
				<xsl:variable name="obj">
					<xsl:value-of select="substring($id,1,3)"/>
				</xsl:variable>
				
				<xsl:variable name="objMaj">
				<xsl:value-of select="translate($obj,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')" />					
				</xsl:variable>		
				<xsl:variable name="etoile">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_hot_cat']/src_img"/>
				</xsl:variable>
				<xsl:variable name="fleur">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_vil_classementvp']/src_img"/>
				</xsl:variable>
				<xsl:variable name="reserver">
					<xsl:value-of select="obj_common/site2"/>
				</xsl:variable>

        <xsl:variable name="chemin_photo">
          <xsl:value-of select="obj_common/photo/ass_obj_photo/fic_z"/>
        </xsl:variable>

        <xsl:variable name="test_vignette">
          <xsl:value-of select="obj_common/photo/ass_obj_photo[vignette=1]/fic_z"/>
        </xsl:variable>
				
				<xsl:variable name="chaine">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_hot_chaine']/src_img"/>
				</xsl:variable>
								
				<xsl:variable name="label">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_label']/src_img"/>
				</xsl:variable>
				
				<xsl:variable name="hlo_epis">
					<xsl:value-of select="obj_common/obj_hlo_spec/nb_epis"/>
				</xsl:variable>
				
				<xsl:variable name="cht_epis">
					<xsl:value-of select="obj_common/obj_cht_spec/nb_epis"/>
				</xsl:variable>
				<xsl:variable name="lien_fiche">
					<xsl:value-of select="concat('../../bourgogne/les-chefs',php:function('creer_lien_ficheV3',string(societe),$id))"/>
				</xsl:variable>
				
			
              <xsl:if test="$chemin_photo!=''">


                <xsl:variable name="chemin">
                  <xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_m,1,4)!='http'">
                    <xsl:if test="$test_vignette!=''">
                      <xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo[doctype='photo' and vignette=1]/fic_z|obj_common/photo/ass_obj_photo[doctype='Image' and vignette=1]/fic_z)"/>
                    </xsl:if>
                    <xsl:if test="$test_vignette=''">
                      <xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo[doctype='photo']/fic_z|obj_common/photo/ass_obj_photo[doctype='Image']/fic_z)"/>

                    </xsl:if>
                  </xsl:if>
                  <xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_z,1,4)='http'">
                    <xsl:if test="$test_vignette!=''">
                      <xsl:value-of select="obj_common/photo/ass_obj_photo[vignette=1]/fic_z"/>
                    </xsl:if>
                    <xsl:if test="$test_vignette=''">
                      <xsl:value-of select="obj_common/photo/ass_obj_photo/fic_z"/>
                    </xsl:if>
                  </xsl:if>
                </xsl:variable>

                <!--
								<xsl:if test="$test_vignette=''">
									<xsl:variable name="chemin">
										<xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_m,21,3)!='://'">

											<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo/fic_m)"/>
										</xsl:if>
										<xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_m,21,3)='://'">
											<xsl:value-of select="concat('http',substring(obj_common/photo/ass_obj_photo/fic_m,21))"/>

										</xsl:if>
									</xsl:variable>
								</xsl:if>
-->


                <div class="swiper-slide" style="background-image:url({$chemin})">
                  <a href="{$lien_fiche}" >
                  <div style="width:100%;height:100%;">
                      <div class="titre-slide-3d"><xsl:value-of select="societe"/></div>
		      <!--<img src="{$chemin}" height="200px" />-->
                   </div>
                  </a>

                </div>

              </xsl:if>				
								
							
	
			</xsl:for-each>	
		  </div>
	</div>
	

</xsl:template>
</xsl:stylesheet>
