﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:php="http://php.net/xsl">
<xsl:output method="html" version="4.0" />
<xsl:template name="coupe">
	<xsl:param name="s" />
	<xsl:if test="contains($s,' ')">
		<xsl:variable name="s2">
			<xsl:call-template name="coupe">
				<xsl:with-param name="s" select="substring-after($s,' ')"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:value-of select="concat(substring-before($s,' '),' ',$s2)"/>
	</xsl:if>
</xsl:template>
<xsl:template name="removeHtmlTags">
    <xsl:param name="html"/>
    <xsl:choose>
      <xsl:when test="contains($html, '&lt;')">
        <xsl:value-of select="substring-before($html, '&lt;')"/>
        <!-- Recurse through HTML -->
        <xsl:call-template name="removeHtmlTags">
          <xsl:with-param name="html" select="substring-after($html, '&gt;')"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$html"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

<xsl:variable name="coul_picto">
		<xsl:value-of select="php:function('getCoul')"/>
</xsl:variable>
<xsl:template match="/">


	
			
			<xsl:for-each select="objs/obj">
			
				<xsl:variable name="id">
					<xsl:value-of select="id"/>
				</xsl:variable>
	
				<xsl:variable name="obj">
					<xsl:value-of select="substring($id,1,3)"/>
				</xsl:variable>
				
				<xsl:variable name="objMaj">
				<xsl:value-of select="translate($obj,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')" />					
				</xsl:variable>		
				<xsl:variable name="etoile">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_hot_cat']/src_img"/>
				</xsl:variable>
				<xsl:variable name="fleur">
					<xsl:value-of select="obj_common/obj_vil_spec/picto_fleur"/>
				</xsl:variable>
				<xsl:variable name="reserver">
					<xsl:value-of select="obj_common/site2"/>
				</xsl:variable>
				<xsl:variable name="test_vignette">
					<xsl:value-of select="obj_common/photo/ass_obj_photo[vignette=1]/fic_m"/>
				</xsl:variable>					
				<xsl:variable name="chemin_photo">
					<xsl:value-of select="obj_common/photo/ass_obj_photo/fic_m"/>
				</xsl:variable>
				
				<xsl:variable name="chaine">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_hot_chaine']/src_img"/>
				</xsl:variable>
								
				<xsl:variable name="label">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_label']/src_img"/>
				</xsl:variable>
				
				<xsl:variable name="hlo_epis">
					<xsl:value-of select="obj_common/obj_hlo_spec/nb_epis"/>
				</xsl:variable>
				
				<xsl:variable name="cht_epis">
					<xsl:value-of select="obj_common/obj_cht_spec/nb_epis"/>
				</xsl:variable>
				<xsl:variable name="lien_fiche">
					<xsl:value-of select="php:function('recuperation_url',$id,string(societe))"/>
				</xsl:variable>
				<xsl:variable name="horaires">
					<xsl:value-of select="obj_common/horaire"/>
				</xsl:variable>
				
				
				
						
							<xsl:if test="$chemin_photo!=''">
							
							
								<xsl:variable name="chemin">										
										<xsl:if test="$test_vignette!=''">
											<xsl:if test="substring(obj_common/photo/ass_obj_photo[vignette=1]/fic_m,1,4)!='http'">
												<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo[doctype='photo' and vignette=1]/fic_m)"/>
											</xsl:if>
											<xsl:if test="substring(obj_common/photo/ass_obj_photo[vignette=1]/fic_m,1,4)='http'">
												<xsl:value-of select="obj_common/photo/ass_obj_photo[vignette=1]/fic_m"/>
											</xsl:if>
										</xsl:if>
										<xsl:if test="$test_vignette=''">
											<xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_m,1,4)!='http'">
												<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo[doctype='photo']/fic_m)"/>
											</xsl:if>
											<xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_m,1,4)='http'">
												<xsl:value-of select="obj_common/photo/ass_obj_photo[doctype='photo']/fic_m"/>
											</xsl:if>
										</xsl:if>
								</xsl:variable>
								
								
									 <!-- <a href="{$lien_fiche}"><div ><img  id="image" src="https://www.cotedor-tourisme.com/fics_monespacetourisme/redim.php?img_Src={$chemin}" style="cursor:pointer;float:right;height:50px;" class="corners iradiae1001" alt="" /></div></a>-->
<!--									<a href="{$lien_fiche}"><div ><img  id="image" src="{$chemin}" style="cursor:pointer;float:right;height:50px;" class="corners iradiae1001" alt="" /></div></a>
									-->
								
								
				          		</xsl:if>
												
					
						
					
					
					
						
						<h2>
						<!--<img src="https://www.cotedor-tourisme.com/pics_communs/icones/gm/{$coul_picto}{$objMaj}.png" style="width:20px;padding-right:3px;" />	-->
						
							<a class="plus" href="{$lien_fiche}"><xsl:value-of select="societe"/></a>
<!--							<xsl:if test="$etoile!=''">
								<sup><img src="{$etoile}"/></sup>
							</xsl:if>
							<xsl:if test="$fleur!=''">
                <xsl:value-of select="$fleur"/>
							</xsl:if>

							<xsl:if test="$cht_epis !=''">
								<xsl:variable name="lien_cht_epis">
									<xsl:value-of select="concat('https://www.cotedor-tourisme.com/pics_communs/epis',$cht_epis,'EP.gif')"/>
								</xsl:variable>	
								<img src="{$lien_cht_epis}"/>
							</xsl:if>
							
							<xsl:if test="$hlo_epis !=''">
								<xsl:variable name="lien_hlo_epis">
									<xsl:value-of select="concat('https://www.cotedor-tourisme.com/pics_communs/epis',$hlo_epis,'EP.gif')"/>
								</xsl:variable>	
								<img src="{$lien_hlo_epis}"/>
							</xsl:if>-->
							
						</h2><b><xsl:value-of select="localite"/></b>
						<xsl:if test="$objMaj='FMA'">
							<xsl:if test="$horaires !=''">
								&#160;-&#160; <i><xsl:value-of select="obj_common/horaire" /></i>
							</xsl:if>
						</xsl:if>
							<br/>
<!--						
							
							<xsl:variable name="descriptif">
								<xsl:value-of select="descriptif_fr"/><br/>
							</xsl:variable>
							
							<xsl:variable name="pureText">
								<xsl:call-template name="removeHtmlTags">
								<xsl:with-param name="html" select="$descriptif" />
								</xsl:call-template>
							</xsl:variable>
							<xsl:call-template name="coupe">
								<xsl:with-param name="s" select="substring(normalize-space($pureText),0,80)"/>
							</xsl:call-template>
							<xsl:if test="$pureText !=''">
								<xsl:text>...</xsl:text>
							</xsl:if>
							-->
							
						
							
<!--						<span class="infoplus">
						<xsl:if test="$chaine!=''">
							<img src="{$chaine}" style="float:right;height:25px;"/> <xsl:text> </xsl:text>
						</xsl:if>
						<xsl:if test="$label!=''">
							<xsl:for-each select="obj_common/ass_all[tbl='ass_label']/src_img">
								<xsl:variable name="lien_label">
									<xsl:value-of select="."/> 
								</xsl:variable>
								<img src="{$lien_label}" style="float:right;height:25px;"/> <xsl:text> </xsl:text>
								
							</xsl:for-each>
						</xsl:if>
						</span>-->
			
			</xsl:for-each>	


</xsl:template>
</xsl:stylesheet>
