﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:php="http://php.net/xsl">
<xsl:output method="html" version="4.0" />
	<xsl:template name="coupe">
		<xsl:param name="s" />
		<xsl:if test="contains($s,' ')">
			<xsl:variable name="s2">
				<xsl:call-template name="coupe">
					<xsl:with-param name="s" select="substring-after($s,' ')"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:value-of select="concat(substring-before($s,' '),' ',$s2)"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="removeHtmlTags">
		<xsl:param name="html"/>
		<xsl:choose>
		  <xsl:when test="contains($html, '&lt;')">
			<xsl:value-of select="substring-before($html, '&lt;')"/>
			<!-- Recurse through HTML -->
			<xsl:call-template name="removeHtmlTags">
			  <xsl:with-param name="html" select="substring-after($html, '&gt;')"/>
			</xsl:call-template>
		  </xsl:when>
		  <xsl:otherwise>
			<xsl:value-of select="$html"/>
		  </xsl:otherwise>
		</xsl:choose>
	  </xsl:template>

	<xsl:variable name="coul_picto">
			<xsl:value-of select="php:function('getCoul')"/>
	</xsl:variable>
	<xsl:template match="/">
		<xsl:for-each select="objs/obj/obj_common/obj_widget/ass_obj_widget[type='gdf']">
			<xsl:variable name="avisGDF">
				<xsl:value-of select="html" disable-output-escaping="yes"/>
			</xsl:variable>
			<xsl:if test="$avisGDF!=''">
				<div id="avisGDF" >		
					<xsl:value-of select="html" disable-output-escaping="yes"/>	
				</div>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
