﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:php="http://php.net/xsl">
<xsl:output method="html" version="4.0" />
<xsl:template name="coupe">
	<xsl:param name="s" />
	<xsl:if test="contains($s,' ')">
		<xsl:variable name="s2">
			<xsl:call-template name="coupe">
				<xsl:with-param name="s" select="substring-after($s,' ')"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:value-of select="concat(substring-before($s,' '),' ',$s2)"/>
	</xsl:if>
</xsl:template>
<xsl:template name="removeHtmlTags">
    <xsl:param name="html"/>
    <xsl:choose>
      <xsl:when test="contains($html, '&lt;')">
        <xsl:value-of select="substring-before($html, '&lt;')"/>
        <!-- Recurse through HTML -->
        <xsl:call-template name="removeHtmlTags">
          <xsl:with-param name="html" select="substring-after($html, '&gt;')"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$html"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

<xsl:variable name="coul_picto">
		<xsl:value-of select="php:function('getCoul')"/>
</xsl:variable>


<xsl:template match="/">
			
			<xsl:for-each select="objs/obj">
				<xsl:variable name="id">
					<xsl:value-of select="id"/>
				</xsl:variable>
	
				<xsl:variable name="obj">
					<xsl:value-of select="substring($id,1,3)"/>
				</xsl:variable>
				
				<xsl:variable name="objMaj">
				<xsl:value-of select="translate($obj,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')" />					
				</xsl:variable>		
				<xsl:variable name="etoile">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_hot_cat']/src_img"/>
				</xsl:variable>
				<xsl:variable name="fleur">
					<xsl:value-of select="obj_common/obj_vil_spec/nb_fleur"/>
				</xsl:variable>
				<xsl:variable name="reserver">
					<xsl:value-of select="obj_common/site2"/>
				</xsl:variable>
					
				<xsl:variable name="chemin_photo">
					<xsl:value-of select="obj_common/photo/ass_obj_photo/fic_z"/>
				</xsl:variable>

				<xsl:variable name="test_vignette">
					<xsl:value-of select="obj_common/photo/ass_obj_photo[vignette=1]/fic_z"/>
				</xsl:variable>
				
				<xsl:variable name="chaine">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_hot_chaine']/src_img"/>
				</xsl:variable>
								
				<xsl:variable name="label">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_label']/src_img"/>
				</xsl:variable>
				
				<xsl:variable name="hlo_epis">
					<xsl:value-of select="obj_common/obj_hlo_spec/nb_epis"/>
				</xsl:variable>
				
				<xsl:variable name="cht_epis">
					<xsl:value-of select="obj_common/obj_cht_spec/nb_epis"/>
				</xsl:variable>
                                <xsl:variable name="lien_fiche">
					<xsl:value-of select="php:function('recuperation_url',$id,string(societe))"/>
				</xsl:variable>
				<xsl:variable name="chemin">
                                    <xsl:if test="$chemin_photo!=''">

                                                                                    <xsl:if test="$test_vignette!=''">
                                                                                            <xsl:if test="substring(obj_common/photo/ass_obj_photo[vignette=1]/fic_z,1,4)!='http'">
                                                                                                    <xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo[doctype='photo' and vignette=1]/fic_z)"/>
                                                                                            </xsl:if>
                                                                                            <xsl:if test="substring(obj_common/photo/ass_obj_photo[vignette=1]/fic_z,1,4)='http'">
                                                                                                    <xsl:value-of select="concat(obj_common/photo/ass_obj_photo[vignette=1]/fic_z,'?width=400')"/>
                                                                                            </xsl:if>
                                                                                    </xsl:if>
                                                                                    <xsl:if test="$test_vignette=''">
                                                                                            <xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_z,1,4)!='http'">
                                                                                                    <xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo[doctype='photo']/fic_z)"/>
                                                                                            </xsl:if>
                                                                                            <xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_z,1,4)='http'">
                                                                                                    <xsl:value-of select="concat(obj_common/photo/ass_obj_photo[doctype='photo']/fic_z,'?width=400')"/>
                                                                                            </xsl:if>
                                                                                    </xsl:if>







                                    </xsl:if>
                                    <xsl:if test="$chemin_photo=''">
                                        <xsl:value-of select="php:function('getDefaultImage')"/>

                                    </xsl:if>		
                                </xsl:variable>
				
				<xsl:variable name="pos"><xsl:value-of select="position()-1"/></xsl:variable>    	
                            <div class="col-xs-12 col-sm-6 col-lg-4 presta-container animated fadeIn visible" data-animation="fadeIn" data-animation-delay="300" style="min-height:250px;/*box-shadow: 2px 2px 1px 1px #cfcfcf;*/">	
                                <a class="plus" href="{$lien_fiche}" >
                                <div class="presta"  data-pos="{$pos}" style="min-height:250px;/*box-shadow: 2px 2px 1px 1px #cfcfcf;*/background: url('{$chemin}');background-size: cover;">	
	 				<xsl:if test="$objMaj='FMA'">
						
					<div class="actu_dates">
                                            <xsl:value-of select="php:function('format_date_actu',string(obj_common/deb_ouv),string(obj_common/date_fin_validite))" disable-output-escaping="yes"/>
                                            <!--<xsl:value-of select="obj_common/deb_ouv"/> 
                                            <br/>V
                                            <xsl:value-of select="obj_common/date_fin_validite"/> -->
                                        </div>  
                                      
                                        </xsl:if>	

<!--					<span class="infoplus" style="float:right;">
                                            <xsl:for-each select="obj_common/ass_all[tbl='ass_hlo_cat']|obj_common/ass_all[tbl='ass_hlo_epis']|obj_common/ass_all[tbl='ass_cht_epis']|obj_common/ass_all[tbl='ass_hco_epis']|obj_common/ass_all[tbl='ass_hpa_cat']|obj_common/ass_all[tbl='ass_hot_cat']">
                                                            <xsl:if test="src_img!=''">
                                                            <img src="{src_img}" alt="{Libelle}" title="{Libelle}" class="floatdroite" style="float:right;height:25px;"  /> <xsl:text> </xsl:text>
                                                            </xsl:if>
                                            </xsl:for-each>							

                                            _________________________________GESTION SPECIFIQUE TOURISME ET HANDICAP ______________________________
                                            <xsl:if test="obj_common[hauditif=1]|obj_common[hmental=1]|obj_common[hmoteur=1]|obj_common[hvisuel=1]">
                                                    <xsl:if test="obj_common[hauditif=1]">
                                                            <img src="https://www.cotedor-tourisme.com/pics_communs/icones/labels/th/hauditif.gif" alt="Labelisé Tourisme et Handicap - auditif" title="Labelisé Tourisme et Handicap - auditif" style="float:right;height:25px;" /> <xsl:text> </xsl:text>
                                                    </xsl:if>

                                                    <xsl:if test="obj_common[hmental=1]">	
                                                            <img src="https://www.cotedor-tourisme.com/pics_communs/icones/labels/th/hmental.gif" alt="Labelisé Tourisme et Handicap - mental" title="Labelisé Tourisme et Handicap - mental" style="float:right;height:25px;" /> <xsl:text> </xsl:text>
                                                    </xsl:if>

                                                    <xsl:if test="obj_common[hmoteur=1]">
                                                            <img src="https://www.cotedor-tourisme.com/pics_communs/icones/labels/th/hmoteur.gif" alt="Labelisé Tourisme et Handicap - moteur" title="Labelisé Tourisme et Handicap - moteur" style="float:right;height:25px;" /> <xsl:text> </xsl:text>
                                                    </xsl:if>

                                                    <xsl:if test="obj_common[hvisuel=1]">									
                                                            <img src="https://www.cotedor-tourisme.com/pics_communs/icones/labels/th/hvisuel.gif" alt="Labelisé Tourisme et Handicap - visuel" title="Labelisé Tourisme et Handicap - visuel" style="float:right;height:25px;" /> <xsl:text> </xsl:text>
                                                    </xsl:if>
                                                    <img src="https://www.cotedor-tourisme.com/pics_communs/icones/labels/th/thandicap_label.gif" alt="Labelisé Tourisme et Handicap" title="Labelisé Tourisme et Handicap" style="float:right;height:25px;" /> <xsl:text> </xsl:text>
                                            </xsl:if>


                                            <xsl:for-each select="obj_common/ass_all">

                                             <xsl:for-each select="obj_common/ass_all[tbl='ass_label']|obj_common/ass_all[tbl='ass_hot_label']|obj_common/ass_all[tbl='ass_hot_chaine']">
                                                            <xsl:if test="src_img!=''">
                                                            <img src="{src_img}" alt="{Libelle}" title="{Libelle}" style="float:right;height:25px;" /> <xsl:text> </xsl:text>
                                                            </xsl:if>
                                            </xsl:for-each>

                                            <xsl:if test="$fleur!=''">
                                              <img src='https://www.cotedor-tourisme.com/pics_communs/icones/{$fleur}fleur.gif'/>
                                            </xsl:if>
							
                                         ______________________________________FIN TOURISME ET HANDICAP___________________________________________

					</span>-->
					<div class="contentBox">

<!--						<xsl:variable name="dist"><xsl:value-of select="obj_common/dist"/></xsl:variable>

							<xsl:if test="$dist!=''">
							<div style="float:right;">
							distance : 
							<xsl:value-of select="obj_common/dist"/><xsl:text>&#x09;km</xsl:text>
							</div>
							</xsl:if>
                                                    -->
						<h4>
                                                   
						<!--<img src="https://www.cotedor-tourisme.com/pics_communs/icones/gm/{$coul_picto}{$objMaj}.png" style="width:20px;padding-right:3px;" />-->	
						
							<xsl:value-of select="societe"/>
							
														
							
							

							<!--<xsl:if test="$etoile!=''">
								<img src="{$etoile}" class="floatdroite" />
							</xsl:if>
							<xsl:if test="$fleur!=''">
									<img src="{$fleur}"/>
							</xsl:if>

							<xsl:if test="$cht_epis !=''">
								<xsl:variable name="lien_cht_epis">
									<xsl:value-of select="concat('https://www.cotedor-tourisme.com/pics_communs/epis',$cht_epis,'EP.gif')"/>
								</xsl:variable>	
								<img src="{$lien_cht_epis}"/>
							</xsl:if>
							
							<xsl:if test="$hlo_epis !=''">
								<xsl:variable name="lien_hlo_epis">
									<xsl:value-of select="concat('https://www.cotedor-tourisme.com/pics_communs/epis',$hlo_epis,'EP.gif')"/>
								</xsl:variable>	
								<img src="{$lien_hlo_epis}"/>
							</xsl:if>-->
							
						</h4>
                                                <xsl:value-of select="localite"/>
                                                <div class="descr">
						

                                                <!--<xsl:if test="$reserver!=''">
								<a href="{$reserver}" class="lien_resa" target="_blank" >
									<IMG src='https://www.cotedor-tourisme.com/sites/all/modules/adt21_engine/images/reserver.gif'/>
								</a><br />
                                                </xsl:if>-->
						<!--<xsl:if test="$objMaj='FMA'">
						<i><xsl:value-of select="obj_common/horaire" /></i><br/>
						</xsl:if>-->
						<xsl:if test="$objMaj='PRD'">
						<i> <xsl:value-of select="obj_common/ass_all[tbl='ass_prd_theme']/Libelle" /></i> <br />
						<i>Séjour proposé par : <xsl:value-of select="obj_common/obj_prd_spec/organisme" /></i><br/>
						</xsl:if>
							
							<xsl:if test="$objMaj='RES'">
							<i>
							<xsl:if test="normalize-space(adresse1)!=''">
							 <br /> <xsl:value-of select="adresse1" />
							
							 </xsl:if>
							 <xsl:if test="normalize-space(obj_common/tel1)!=''">
							  <br /> tél : <xsl:value-of select="obj_common/tel1" />
							 </xsl:if>
							<!-- TARIFS RES -->
							
							
								
								<xsl:for-each select="obj_common/ass_all_tar[tbl='ass_res_tarif' and annee='2013']">
								<xsl:if test="code='ADULT'">
								<br/>
								<xsl:value-of select="Libelle"/>
								<xsl:text>:</xsl:text>
								<xsl:variable name="mini_euro">
								<xsl:value-of select="mini_euro"/>
								</xsl:variable>
								<xsl:variable name="maxi_euro">
								<xsl:value-of select="maxi_euro"/>
								</xsl:variable>
								<xsl:if test="$mini_euro=$maxi_euro">
								Tarif unique de
								<xsl:value-of select="maxi_euro"/>
								euros
								</xsl:if>
								<xsl:if test="$maxi_euro='' and $mini_euro!=''">
								Tarif à partir de
								<xsl:value-of select="mini_euro"/>
								euros
								</xsl:if>
								<xsl:if test="$mini_euro='' and $maxi_euro!=''">
								Tarif jusqu'à
								<xsl:value-of select="maxi_euro"/>
								euros
								</xsl:if>
								<xsl:if test="$maxi_euro!=$mini_euro and $maxi_euro!='' and $mini_euro!=''">
								Tarif à partir de
								<xsl:value-of select="mini_euro"/>
								euros jusqu'à
								<xsl:value-of select="maxi_euro"/>
								euros
								
								</xsl:if>
								
								</xsl:if>
								
								</xsl:for-each>
			
								
							<!--FIN TAR RES-->
							
							
							
							
							
							
							</i>
							</xsl:if>
							<br />
							<xsl:variable name="descriptif">
								<xsl:value-of select="descriptif_fr"/><br/>
							</xsl:variable>
							
							<xsl:variable name="pureText">
								<xsl:call-template name="removeHtmlTags">
								<xsl:with-param name="html" select="$descriptif" />
								</xsl:call-template>
							</xsl:variable>
                                                        <!--
							<xsl:call-template name="coupe">
								<xsl:with-param name="s" select="substring(normalize-space($pureText),0,150)"/>
							</xsl:call-template>
							<xsl:if test="normalize-space($pureText) !=''">
							
								<xsl:text>...</xsl:text><br/>	
							</xsl:if>-->
							
							
							
							
                                                       <!-- <span class="btn_openpresta">
							<a class="btn btn-default" href="{$lien_fiche}" style=""><i class=" demo-icon icon-plus fa-3x"></i></a>
                                                        </span>-->
						
					</div>
                                    </div>    
				</div>
                                </a>
                            </div>
	
			</xsl:for-each>	
			
	

</xsl:template>
</xsl:stylesheet>
