﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:php="http://php.net/xsl">
<xsl:output method="html" version="4.0" />
<xsl:template name="coupe">
	<xsl:param name="s" />
	<xsl:if test="contains($s,' ')">
		<xsl:variable name="s2">
			<xsl:call-template name="coupe">
				<xsl:with-param name="s" select="substring-after($s,' ')"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:value-of select="concat(substring-before($s,' '),' ',$s2)"/>
	</xsl:if>
</xsl:template>
<xsl:template name="removeHtmlTags">
    <xsl:param name="html"/>
    <xsl:choose>
      <xsl:when test="contains($html, '&lt;')">
        <xsl:value-of select="substring-before($html, '&lt;')"/>
        <!-- Recurse through HTML -->
        <xsl:call-template name="removeHtmlTags">
          <xsl:with-param name="html" select="substring-after($html, '&gt;')"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$html"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="nl2br">
	<xsl:param name="string"/>
	<xsl:value-of select="normalize-space(substring-before($string,'&#10;'))"/>
	<xsl:choose>
		<xsl:when test="contains($string,'&#10;')">
			<br style="mso-data-placement:same-cell;"/> 
			<xsl:call-template name="nl2br">
				<xsl:with-param name="string" select="substring-after($string,'&#10;')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$string"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:variable name="coul_picto">
		<xsl:value-of select="php:function('getCoul')"/>
</xsl:variable>


<xsl:template match="/">


	
			<table cellspacing="0" cellpadding="0" width="100%" style=" border-width:1px; border-style:solid; border-collapse: initial;border-color:black;background-color:black;">
			<xsl:for-each select="objs/obj">
				<xsl:variable name="id">
					<xsl:value-of select="id"/>
				</xsl:variable>
	
				<xsl:variable name="obj">
					<xsl:value-of select="substring($id,1,3)"/>
				</xsl:variable>
				
				<xsl:variable name="objMaj">
				<xsl:value-of select="translate($obj,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')" />					
				</xsl:variable>		
				<xsl:variable name="etoile">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_hot_cat']/src_img"/>
				</xsl:variable>
				<xsl:variable name="fleur">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_vil_classementvp']/src_img"/>
				</xsl:variable>
				<xsl:variable name="reserver">
					<xsl:value-of select="obj_common/site2"/>
				</xsl:variable>
					
				<xsl:variable name="chemin_photo">
					<xsl:value-of select="obj_common/photo/ass_obj_photo/fic_m"/>
				</xsl:variable>

				<xsl:variable name="test_vignette">
					<xsl:value-of select="obj_common/photo/ass_obj_photo[vignette=1]/fic_m"/>
				</xsl:variable>
				
				<xsl:variable name="chaine">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_hot_chaine']/src_img"/>
				</xsl:variable>
								
				<xsl:variable name="label">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_label']/src_img"/>
				</xsl:variable>
				
				<xsl:variable name="hlo_epis">
					<xsl:value-of select="obj_common/obj_hlo_spec/nb_epis"/>
				</xsl:variable>
				
				<xsl:variable name="cht_epis">
					<xsl:value-of select="obj_common/obj_cht_spec/nb_epis"/>
				</xsl:variable>
				<xsl:variable name="lien_fiche">
					<xsl:value-of select="php:function('creer_lien_fiche',string(societe),$id)"/>
				</xsl:variable>
				
				
				<tr>	
					
					
					
					
					<td  style="border: 1px solid #161414;mso-data-placement:same-cell;" >
					
				
						<b style="mso-data-placement:same-cell;">
						<xsl:value-of select="societe"/>
							
														
							
							
							 <xsl:for-each select="obj_common/ass_all[tbl='ass_hlo_cat']|obj_common/ass_all[tbl='ass_hlo_epis']|obj_common/ass_all[tbl='ass_cht_epis']|obj_common/ass_all[tbl='ass_hpa_cat']|obj_common/ass_all[tbl='ass_hot_cat']">
									<xsl:if test="src_img!=''">
									<img src="{src_img}" alt="{Libelle}" title="{Libelle}" style="float:right;height:25px;" /> <xsl:text> </xsl:text>
									</xsl:if>
									
							</xsl:for-each>

						
							
						
							
						</b><br style="mso-data-placement:same-cell;"/> 
						<xsl:variable name="descriptif">
							<xsl:value-of select="descriptif_fr"/>
						</xsl:variable>
						
						
						<xsl:call-template name="nl2br">
							<xsl:with-param name="string" select="$descriptif"/>
						</xsl:call-template>
						<br style="mso-data-placement:same-cell;"/> 
						<xsl:if test="$objMaj='FMA'">
						<i><xsl:value-of select="obj_common/horaire" /></i><br/>
						</xsl:if>
						<xsl:if test="$objMaj='PRD'">
						<i> <xsl:value-of select="obj_common/ass_all[tbl='ass_prd_theme']/Libelle" /></i> <br style="mso-data-placement:same-cell;"/> 
						<i>Séjour proposé par : <xsl:value-of select="obj_common/obj_prd_spec/organisme" /></i><br/>
						</xsl:if>
													
							
							<xsl:if test="normalize-space(adresse1)!=''">
							 <xsl:value-of select="adresse1" /><br style="mso-data-placement:same-cell;"/> 
							
							 </xsl:if>
							 			
							<xsl:if test="normalize-space(adresse2)!=''">
							 <xsl:value-of select="adresse2" /><br style="mso-data-placement:same-cell;"/> 
							
							 </xsl:if>
							 			
							<xsl:if test="normalize-space(adresse3)!=''">
							 <xsl:value-of select="adresse3" /><br style="mso-data-placement:same-cell;"/> 
							
							 </xsl:if>
							 <xsl:if test="normalize-space(obj_common/tel1)!=''">
							  Tél.<xsl:text> </xsl:text><xsl:value-of select="obj_common/tel1" /><br style="mso-data-placement:same-cell;"/> 
							 </xsl:if>
							  <xsl:if test="normalize-space(obj_common/tel2)!=''">
							  Tél2. <xsl:text> </xsl:text><xsl:value-of select="obj_common/tel2" />
							 </xsl:if>
							 
							<!-- TARIFS RES -->
							
							
								
								<xsl:for-each select="obj_common/ass_all_tar[tbl='ass_res_tarif' and annee='2013']">
								<xsl:if test="code='ADULT'">
								<br/>
								<xsl:value-of select="Libelle"/>
								<xsl:text>:</xsl:text>
								<xsl:variable name="mini_euro">
								<xsl:value-of select="mini_euro"/>
								</xsl:variable>
								<xsl:variable name="maxi_euro">
								<xsl:value-of select="maxi_euro"/>
								</xsl:variable>
								<xsl:if test="$mini_euro=$maxi_euro">
								Tarif unique de
								<xsl:value-of select="maxi_euro"/>
								euros
								</xsl:if>
								<xsl:if test="$maxi_euro='' and $mini_euro!=''">
								Tarif à partir de
								<xsl:value-of select="mini_euro"/>
								euros
								</xsl:if>
								<xsl:if test="$mini_euro='' and $maxi_euro!=''">
								Tarif jusqu'à
								<xsl:value-of select="maxi_euro"/>
								euros
								</xsl:if>
								<xsl:if test="$maxi_euro!=$mini_euro and $maxi_euro!='' and $mini_euro!=''">
								Tarif à partir de
								<xsl:value-of select="mini_euro"/>
								euros jusqu'à
								<xsl:value-of select="maxi_euro"/>
								euros
								
								</xsl:if>
								
								</xsl:if>
								
								</xsl:for-each>
			
								
							<!--FIN TAR RES-->
							
							
							
							
							
							
						
							
							<br style="mso-data-placement:same-cell;"/> 
						
								
							
							
											
														
						
							
						<span class="infoplus" style="float:right;">
							
							
							<!--_________________________________GESTION SPECIFIQUE TOURISME ET HANDICAP ______________________________-->
							<xsl:if test="obj_common[hauditif=1]|obj_common[hmental=1]|obj_common[hmoteur=1]|obj_common[hvisuel=1]">
								<xsl:if test="obj_common[hauditif=1]">
									<img src="https://www.cotedor-tourisme.com/pics_communs/icones/labels/th/hauditif.gif" alt="Labelisé Tourisme et Handicap - auditif" title="Labelisé Tourisme et Handicap - auditif" style="float:right;height:25px;" /> <xsl:text> </xsl:text>
								</xsl:if>
							
								<xsl:if test="obj_common[hmental=1]">	
									<img src="https://www.cotedor-tourisme.com/pics_communs/icones/labels/th/hmental.gif" alt="Labelisé Tourisme et Handicap - mental" title="Labelisé Tourisme et Handicap - mental" style="float:right;height:25px;" /> <xsl:text> </xsl:text>
								</xsl:if>
							
								<xsl:if test="obj_common[hmoteur=1]">
									<img src="https://www.cotedor-tourisme.com/pics_communs/icones/labels/th/hmoteur.gif" alt="Labelisé Tourisme et Handicap - moteur" title="Labelisé Tourisme et Handicap - moteur" style="float:right;height:25px;" /> <xsl:text> </xsl:text>
								</xsl:if>
							
								<xsl:if test="obj_common[hvisuel=1]">									
									<img src="https://www.cotedor-tourisme.com/pics_communs/icones/labels/th/hvisuel.gif" alt="Labelisé Tourisme et Handicap - visuel" title="Labelisé Tourisme et Handicap - visuel" style="float:right;height:25px;" /> <xsl:text> </xsl:text>
								</xsl:if>
								<img src="https://www.cotedor-tourisme.com/pics_communs/icones/labels/th/thandicap_label.gif" alt="Labelisé Tourisme et Handicap" title="Labelisé Tourisme et Handicap" style="float:right;height:25px;" /> <xsl:text> </xsl:text>
							</xsl:if>
						
							
							<!--<xsl:for-each select="obj_common/ass_all">-->
							
							 <xsl:for-each select="obj_common/ass_all[tbl='ass_label']|obj_common/ass_all[tbl='ass_hot_label']|obj_common/ass_all[tbl='ass_hot_chaine']">
									<xsl:if test="src_img!=''">
									<img src="{src_img}" alt="{Libelle}" title="{Libelle}" style="float:right;height:25px;" /> <xsl:text> </xsl:text>
									</xsl:if>
							</xsl:for-each>
							
								<!-- ______________________________________FIN TOURISME ET HANDICAP___________________________________________-->
									
							
							
							
					
						</span>
					</td>
					<td style="border: 1px solid #161414;">
						<xsl:value-of select="id"/>
					
					</td>
					<td  style="border: 1px solid #161414;">
						<xsl:value-of select="societe"/>
					
					</td>
					<td style="border: 1px solid #161414;">
						<xsl:value-of select="localite"/>
					
					</td>
					
					<td style="border: 1px solid #161414;">
							<xsl:for-each select="obj_common/ass_all[tbl='ass_hlo_cat']|obj_common/ass_all[tbl='ass_hlo_epis']|obj_common/ass_all[tbl='ass_cht_epis']|obj_common/ass_all[tbl='ass_hpa_cat']|obj_common/ass_all[tbl='ass_hot_cat']">
								
									<xsl:value-of select="Libelle" /><xsl:text>;</xsl:text>
									
							</xsl:for-each>
							 <xsl:for-each select="obj_common/ass_all[tbl='ass_label']|obj_common/ass_all[tbl='ass_hot_label']|obj_common/ass_all[tbl='ass_hot_chaine']">
									<xsl:value-of select="Libelle" /><xsl:text>;</xsl:text>
									
							</xsl:for-each>
																			<xsl:if test="obj_common[hauditif=1]|obj_common[hmental=1]|obj_common[hmoteur=1]|obj_common[hvisuel=1]">
								<xsl:if test="obj_common[hauditif=1]">
									Labelisé Tourisme et Handicap - auditif;
								</xsl:if>
							
								<xsl:if test="obj_common[hmental=1]">	
									<xsl:text> Labelisé Tourisme et Handicap - mental ;</xsl:text>
								</xsl:if>
							
								<xsl:if test="obj_common[hmoteur=1]">
									<xsl:text> Labelisé Tourisme et Handicap - moteur ; </xsl:text>
								</xsl:if>
							
								<xsl:if test="obj_common[hvisuel=1]">									
									<xsl:text> Labelisé Tourisme et Handicap - visuel ; </xsl:text>
								</xsl:if>
								<xsl:text>Labelisé Tourisme et Handicap ; </xsl:text>
							</xsl:if>
					</td>
					<td style="border: 1px solid #161414;">Nombre de photos :<xsl:value-of select="obj_common/nb_photos" /></td>
				</tr>
				
	
			</xsl:for-each>	
			</table>
	

</xsl:template>
</xsl:stylesheet>
