﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:php="http://php.net/xsl" >



<xsl:template name="coupe">
	<xsl:param name="s" />
	<xsl:if test="contains($s,' ')">
		<xsl:variable name="s2">
			<xsl:call-template name="coupe">
				<xsl:with-param name="s" select="substring-after($s,' ')"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:value-of select="concat(substring-before($s,' '),' ',$s2)"/>
	</xsl:if>
</xsl:template>



<xsl:template match="/">


	
		<div class="ActuMenuCarousel" data-items="1" data-responsive="1" data-items-desktop-small="1" data-items-tablet="1" data-items-mobile="1" data-auto="0" data-navigation="true" data-pagination="false">	
			<xsl:for-each select="objs/obj">
			<div class=" awe-carousel-slide">
				<xsl:variable name="id">
					<xsl:value-of select="id"/>
				</xsl:variable>
	
				<xsl:variable name="obj">
					<xsl:value-of select="substring($id,1,3)"/>
				</xsl:variable>
				
				<xsl:variable name="objMaj">
				<xsl:value-of select="translate($obj,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')" />					
				</xsl:variable>		
				<xsl:variable name="etoile">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_hot_cat']/src_img"/>
				</xsl:variable>
					
				
				
				<xsl:variable name="chaine">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_hot_chaine']/src_img"/>
				</xsl:variable>
								
				<xsl:variable name="label">
					<xsl:value-of select="obj_common/ass_all[tbl='ass_label']/src_img"/>
				</xsl:variable>
				
				<xsl:variable name="hlo_epis">
					<xsl:value-of select="obj_common/obj_hlo_spec/nb_epis"/>
				</xsl:variable>
				
				<xsl:variable name="cht_epis">
					<xsl:value-of select="obj_common/obj_cht_spec/nb_epis"/>
				</xsl:variable>
				
				<xsl:variable name="lien_fiche">
						<xsl:value-of select="php:function('creer_lien_fiche',string(societe),$id)"/>
						</xsl:variable>
				<xsl:variable name="chemin_photo">
					<xsl:value-of select="obj_common/photo/ass_obj_photo/fic_z"/>
				</xsl:variable>	
				<xsl:variable name="test_vignette">
					<xsl:value-of select="obj_common/photo/ass_obj_photo[vignette=1]/fic_z"/>
				</xsl:variable>				
				<xsl:if test="$chemin_photo!=''">
									<xsl:variable name="chemin">										
										<xsl:if test="$test_vignette!=''">
											<xsl:if test="substring(obj_common/photo/ass_obj_photo[vignette=1]/fic_z,1,4)!='http'">
												<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo[doctype='photo' and vignette=1]/fic_z)"/>
											</xsl:if>
											<xsl:if test="substring(obj_common/photo/ass_obj_photo[vignette=1]/fic_z,1,4)='http'">
												<xsl:value-of select="obj_common/photo/ass_obj_photo[vignette=1]/fic_z"/>
											</xsl:if>
										</xsl:if>
										<xsl:if test="$test_vignette=''">
											<xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_z,1,4)!='http'">
												<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo[doctype='photo']/fic_z)"/>
											</xsl:if>
											<xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_z,1,4)='http'">
												<xsl:value-of select="obj_common/photo/ass_obj_photo[doctype='photo']/fic_z"/>
											</xsl:if>
										</xsl:if>
									</xsl:variable>
		</xsl:if>
						<div class="texteactuacc">
                                                <a href="/agenda{$lien_fiche}">
						<div class="actu_dates">
                                                    <xsl:value-of select="php:function('format_date_actu',string(obj_common/deb_ouv),string(obj_common/date_fin_validite))" disable-output-escaping="yes"/>
                                                    <!--<xsl:value-of select="obj_common/deb_ouv"/> 
                                                    <br/>V
                                                    <xsl:value-of select="obj_common/date_fin_validite"/> -->
                                                </div>    
						<h4 style="font-weight: bolder;padding: 5px;color:rgb(84, 157, 108);">
						
						
							<xsl:value-of select="societe"/>
							
							
						</h4>
												
		
						
						
					
						
						
					
							
							<xsl:if test="$objMaj='FMA'">
								à <span class="actu_lieu"> <xsl:value-of select="localite"/></span><br/>
							</xsl:if>
							
						
							
							<xsl:variable name="descriptif">
								<xsl:value-of select="php:function('strip_tags',string(descriptif_fr))"/><br/>
							</xsl:variable>
							<!--<xsl:call-template name="coupe">
								<xsl:with-param name="s" select="substring(normalize-space($descriptif),0,70)"/>
							</xsl:call-template>
							<xsl:if test="$descriptif !=''">
								<xsl:text>...</xsl:text>
								
							</xsl:if>	-->		
							
							
						</a>	
						</div>
                                        </div>
				</xsl:for-each>	
                </div>

	

</xsl:template>
</xsl:stylesheet>
