﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template name="strip-tags">
	<xsl:param name="descriptif" select="objs/obj/descriptif_fr"/>
	<xsl:choose>
		<xsl:when test="contains($descriptif, '&lt;')">
			<xsl:value-of select="substring-before($descriptif, '&lt;')"/>
			<xsl:call-template name="strip-tags">
				<xsl:with-param name="descriptif" select="substring-after($descriptif, '&gt;')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$descriptif"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

 <xsl:variable name="_crlf"><xsl:text>
</xsl:text></xsl:variable>
  <xsl:variable name="crlf" select="string($_crlf)"/>

  <xsl:template name="crlf-replace">
    <xsl:param name="subject"/>

    <xsl:choose>
      <xsl:when test="contains($subject, $crlf)">
    <xsl:value-of select="substring-before($subject, $crlf)"/><br/>
    <xsl:call-template name="crlf-replace">
      <xsl:with-param name="subject" select="substring-after($subject, $crlf)"/>
    </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
    <xsl:value-of select="$subject"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  
  
<xsl:template match="/">




<xsl:variable name="image_existante">
				<xsl:value-of select="objs/obj/obj_common/photo/ass_obj_photo[doctype='Photo']"/>
</xsl:variable>
<!--<xsl:choose>
	<xsl:when test="$image_existante!=''">-->
		<xsl:variable name="imageo">
								<!--<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_o)"/>-->
				background-image: url('<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',objs/obj/obj_common/photo/ass_obj_photo[doctype='Photo']/fic_o)"/>');
		</xsl:variable>
		<!--<body style="background-color:#EFEFEF;	background-image: url({$imageo});background-attachment: fixed;background-repeat: repeat-y;">	-->
	<!--</xsl:when>
	<xsl:otherwise>
	<xsl:variable name="imageo"></xsl:variable>		
	</xsl:otherwise>
</xsl:choose>-->

<!--<div style="background-color:#EFEFEF;	{$imageo}background-attachment: fixed;background-repeat: no-repeat;background-size:900px;">	
-->


	<div id="conteneur">
		<xsl:variable name="id">
			<xsl:value-of select="objs/obj/id"/>
		</xsl:variable>
		
		
		
					<xsl:for-each select="/objs/obj/obj_common/ass_all[tbl='ass_hot_chaine']|/objs/obj/obj_common/ass_all[tbl='ass_label']">
					<xsl:if test="src_img!=''">
						<img src="{src_img}" alt="{Libelle}" title="{Libelle}" style="float:right;" /><xsl:text>&#160;</xsl:text>
					</xsl:if>
					</xsl:for-each>
		
		<h1>
		<xsl:value-of select="objs/obj/societe"/>
		<xsl:variable name="etoile">
			<xsl:value-of select="/objs/obj/obj_common/ass_all[tbl='ass_hot_cat']/src_img"/>
		</xsl:variable>
		<xsl:if test="$etoile!=''">
			<img src="{$etoile}"/>
		</xsl:if>
		
			

		</h1>
		<!--<div id="menu">
			<ul>
				<li class="first"><a href="#">Présentation</a></li>
				<li><a href="#">Localisation</a></li>
				<li><a href="#">Loisirs et Services</a></li>
				<xsl:variable name="image_existante">
					<xsl:value-of select="objs/obj/obj_common/photo/ass_obj_photo[doctype='Photo']"/>
				</xsl:variable>
				<xsl:if test="$image_existante!=''">
					<li><a href="#">Gallerie photos</a></li>
				</xsl:if>
			</ul>
		</div>-->
		<div id="contenu" >
			
				
			<xsl:if test="$image_existante!=''">
			<div id="diapo" style="margin:30px;">
				<!--<div class="pikachoose" style="float:right;">
					<ul id="pikame" class="jcarousel-skin-pika">
						<xsl:for-each select="objs/obj/obj_common/photo/ass_obj_photo[doctype='Photo']">
							<xsl:variable name="image">-->
								<!--<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_o)"/>-->
								<!--<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_z)"/>
							</xsl:variable>
							<li><img src="{$image}"/></li>
						</xsl:for-each>	
					</ul>
				</div>-->
				
				<div id="gallery" class="ad-gallery">
				<div class="ad-image-wrapper">-</div>
				<div class="ad-controls"> -
				</div>
				<div class="ad-nav">
					<div class="ad-thumbs">
						<ul class="ad-thumb-list">
           
						<xsl:for-each select="objs/obj/obj_common/photo/ass_obj_photo[doctype='Photo']">
							<xsl:variable name="image">
								<!--<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_o)"/>-->
								<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_z)"/>
							</xsl:variable>
							<xsl:variable name="imagem">
								<!--<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_o)"/>-->
								<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_m)"/>
							</xsl:variable>
							<xsl:variable name="copyr">
								<!--<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_o)"/>-->
								<xsl:value-of select="copyright"/>
							</xsl:variable>		
							<xsl:variable name="titre">
								<!--<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_o)"/>-->
								<xsl:value-of select="titre"/>
							</xsl:variable>							
							 <li>
								<a href="{$image}">
								<img src="{$imagem}" title="{$copyr}" alt="{$titre}" class="image1" />
								</a>
							</li>
						</xsl:for-each>	           
						</ul>
					</div>
				</div>
				</div>
			
			</div>
			</xsl:if>
			<xsl:variable name="descriptif">
				<xsl:value-of select="objs/obj/descriptif_fr"/>
			</xsl:variable>
			<div id="contenu_left">
			<div id="ligne">
			<xsl:if test="$descriptif!=''">
				<h2>DESCRIPTION</h2>
				<xsl:value-of select="objs/obj/descriptif_fr"/>
			</xsl:if>
			</div>
			<!--<xsl:variable name="tarifs_existant">
				<xsl:value-of select="objs/obj/obj_common/ass_all_tar[tbl='ass_hot_tarif']/mini_euro"/>
			</xsl:variable>
			<div id="ligne">
			<xsl:if test="$tarifs_existant!=''">
				<h2>TARIFS</h2>
				<xsl:variable name="tarif_mini">
					<xsl:value-of select="objs/obj/obj_common/ass_all_tar[tbl='ass_hot_tarif']/mini_euro"/>
				</xsl:variable>
				<xsl:variable name="tarif_maxi">
					<xsl:value-of select="objs/obj/obj_common/ass_all_tar[tbl='ass_hot_tarif']/maxi_euro"/>
				</xsl:variable>
				<xsl:if test="$tarif_mini!='' or $tarif_maxi!=''">
					<xsl:for-each select="objs/obj/obj_common/ass_all_tar[tbl='ass_hot_tarif']">
						<li>
							<xsl:value-of select="Libelle"/> 
							<xsl:text> : </xsl:text>
							<xsl:variable name="mini_euro">
								<xsl:value-of select="mini_euro"/> 
							</xsl:variable>
							<xsl:variable name="maxi_euro">
								<xsl:value-of select="maxi_euro"/>
							</xsl:variable>
							<xsl:if test="$mini_euro=$maxi_euro">
								Tarif unique de <xsl:value-of select="maxi_euro"/>€
							</xsl:if>
							<xsl:if test="$maxi_euro='' and $mini_euro!=''">
								Tarif à partir de <xsl:value-of select="mini_euro"/>€
							</xsl:if>
							<xsl:if test="$mini_euro='' and $maxi_euro!=''">
								Tarif jusqu'à <xsl:value-of select="maxi_euro"/>€
							</xsl:if>
							<xsl:if test="$maxi_euro!=$mini_euro and $maxi_euro!='' and $mini_euro!=''">
								Tarif à partir de <xsl:value-of select="mini_euro"/>€  jusqu'à <xsl:value-of select="maxi_euro"/>€
							</xsl:if>
						</li>
					</xsl:for-each>
				</xsl:if>	
			</xsl:if>
			</div>-->
			
			<xsl:variable name="tarif_mini_existant">
				<xsl:value-of select="objs/obj/obj_common/ass_all_tar/mini_euro"/>
			</xsl:variable>
			
			<xsl:variable name="tarif_maxi_existant">
				<xsl:value-of select="objs/obj/obj_common/ass_all_tar/mini_euro"/>
			</xsl:variable>
			
			<xsl:variable name="tarif_libelle_existant">
				<xsl:value-of select="objs/obj/obj_common/ass_all_tar/Libelle"/>
			</xsl:variable>

			<xsl:if test="$tarif_mini_existant!='' or $tarif_maxi_existant!='' or $tarif_libelle_existant!=''">
				<div id="ligne">
				<h2>TARIFS</h2>
				<ul title="Tarifs" id="tarifs">
					<xsl:variable name="tarif_mini">
						<xsl:value-of select="objs/obj/obj_common/ass_all_tar/mini_euro"/>
					</xsl:variable>
					<xsl:variable name="tarif_maxi">
						<xsl:value-of select="objs/obj/obj_common/ass_all_tar/maxi_euro"/>
					</xsl:variable>
					<xsl:variable name="tarif_libelle">
						<xsl:value-of select="objs/obj/obj_common/ass_all_tar/Libelle"/>
					</xsl:variable>
					<xsl:variable name="tarif_complement">
						<xsl:value-of select="objs/obj/obj_common/ass_all_tar/complement"/>
					</xsl:variable>
					<xsl:variable name="mini_euro2">
						<xsl:value-of select="objs/obj/obj_common/ass_all_tar/mini_euro"/> 
					</xsl:variable>
					<xsl:variable name="maxi_euro2">
						<xsl:value-of select="objs/obj/obj_common/ass_all_tar/maxi_euro"/>
					</xsl:variable>
					<xsl:if test="$tarif_mini!='' or $tarif_maxi!=''">
						<xsl:for-each select="objs/obj/obj_common/ass_all_tar">
							<li>
								<xsl:value-of select="Libelle"/> 
								<xsl:text> : </xsl:text>
								<xsl:variable name="mini_euro">
									<xsl:value-of select="mini_euro"/> 
								</xsl:variable>
								<xsl:variable name="maxi_euro">
									<xsl:value-of select="maxi_euro"/>
								</xsl:variable>
								<xsl:if test="$mini_euro=$maxi_euro">
									Tarif unique de <xsl:value-of select="maxi_euro"/>€
									<xsl:if test="$tarif_complement!=''">
										(<xsl:value-of select="complement"/>)
									</xsl:if>
								</xsl:if>
								<xsl:if test="$maxi_euro='' and $mini_euro!=''">
									Tarif à partir de <xsl:value-of select="mini_euro"/>€
									<xsl:if test="$tarif_complement!=''">
										(<xsl:value-of select="complement"/>)
									</xsl:if>
								</xsl:if>
								<xsl:if test="$mini_euro='' and $maxi_euro!=''">
									Tarif jusqu'à <xsl:value-of select="maxi_euro"/>€
									<xsl:if test="$tarif_complement!=''">
										(<xsl:value-of select="complement"/>)
									</xsl:if>
								</xsl:if>
								<xsl:if test="$maxi_euro!=$mini_euro and $maxi_euro!='' and $mini_euro!=''">
									Tarif à partir de <xsl:value-of select="mini_euro"/>€  jusqu'à <xsl:value-of select="maxi_euro"/>€
									<xsl:if test="$tarif_complement!=''">
										(<xsl:value-of select="complement"/>)
									</xsl:if>
								</xsl:if>
							</li>
						</xsl:for-each>
					</xsl:if>	
					<xsl:if test="$tarif_libelle!='' and $mini_euro2='' and $maxi_euro2=''">
						<xsl:value-of select="objs/obj/obj_common/ass_all_tar/Libelle"/>
					</xsl:if>
					
			
				</ul>
				</div>
			</xsl:if>
			
			<xsl:variable name="horaires_existant">
				<xsl:value-of select="objs/obj/obj_common/horaire"/>
			</xsl:variable>
			<xsl:if test="$horaires_existant!=''">
				<h2>HORAIRES</h2>
				<xsl:value-of select="objs/obj/obj_common/horaire"/>
			</xsl:if>
			</div>
			
			<div id="contenu_right">
			<xsl:variable name="adresse_existante">
				<xsl:value-of select="objs/obj/adresse1"/>
			</xsl:variable>
			
			<xsl:if test="$adresse_existante!=''">
				<h2 > ADRESSE </h2>
				<p id="adresse"><xsl:value-of select="objs/obj/adresse1"/></p>
				<p id="ville"><xsl:value-of select="objs/obj/cp"/><xsl:text> </xsl:text><xsl:value-of select="objs/obj/localite"/></p>
 			</xsl:if>
			
			<xsl:variable name="telephone">
				<xsl:value-of select="objs/obj/obj_common/tel1"/>
			</xsl:variable>
			<xsl:if test="$telephone!=''">
				<p id="ligne"><xsl:value-of select="objs/obj/obj_common/tel1"/></p> 
			</xsl:if>
			
			<xsl:variable name="email">
				<xsl:value-of select="objs/obj/obj_common/mel1"/>
			</xsl:variable>
			<xsl:if test="$email!=''">
				<p><a href="mailto:{$email}"><xsl:value-of select="objs/obj/obj_common/mel1"/></a></p>  	
			</xsl:if>
			
			<xsl:variable name="site">
				<xsl:value-of select="objs/obj/obj_common/site1"/>
			</xsl:variable>
			<xsl:if test="$site!=''">
				<p><a href="{$site}"><xsl:value-of select="objs/obj/obj_common/site1"/></a></p>  	
			</xsl:if>
			</div>
			
		</div>
	</div>
<!--</div>-->


</xsl:template>
</xsl:stylesheet>
