﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:template match="/">
<html>
<head>
	<link href="style_fiche.css" rel="stylesheet" type="text/css" media="screen, projection"/> 
	<link href="jquery.diaporama/style.css" rel="stylesheet" type="text/css" media="screen, projection"/> 
	<link href="onglet.css" rel="stylesheet" type="text/css" media="screen, projection"/> 
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
	<meta http-equiv="Content-Script-Type" content="text/javascript"/>
	<script type="text/javascript" src="jquery.diaporama/js/jquery-1.3.2.min.js"></script>
	<script type="text/javascript" src="jquery.diaporama/js/jquery.diaporama.js"></script>
	<script type="text/javascript" src="jquery.diaporama/js/script.js"></script>
</head>
<body>
	
	<div id="content">
	<hr/>

	<div class="back"> <a href="index.php">Retour au listing des hôtels</a></div>
	
	<xsl:variable name="id">
		<xsl:value-of select="objs/obj/id"/>
	</xsl:variable>
	
	<ul>  
		<li id="onglet_selectionne">Descriptif</li> 
		<li id="navfiche"><a href="carte.php?id={$id}">Plan</a></li>
	</ul>
	
		
	<h1><xsl:value-of select="objs/obj/societe"/>
			<xsl:variable name="etoile">
				<xsl:value-of select="/objs/obj/obj_common/ass_all[tbl='ass_hot_cat']/src_img"/>
			</xsl:variable>
				
			<xsl:if test="$etoile!=''">
				<sup><img src="{$etoile}"/></sup>
			</xsl:if>
				</h1>
	
	
	<xsl:variable name="image_existante">
		<xsl:value-of select="objs/obj/obj_common/photo/ass_obj_photo"/>
	</xsl:variable>
	<xsl:if test="$image_existante!=''">
	
	<div id="Informations_right">
						<p><xsl:value-of select="objs/obj/adresse1"/></p>
						<p><xsl:value-of select="objs/obj/cp"/> - 
							<xsl:value-of select="objs/obj/localite"/></p>
							
						
						<xsl:variable name="telephone">
							<xsl:value-of select="objs/obj/obj_common/tel1"/>
						</xsl:variable>
						<xsl:if test="$telephone!=''">
							<p>
								<strong>Téléphone : </strong>
								<xsl:value-of select="objs/obj/obj_common/tel1"/>
							</p>
						</xsl:if>	
							
						
						
						<xsl:variable name="fax">
							<xsl:value-of select="objs/obj/obj_common/fax1"/>
						</xsl:variable>
						<xsl:if test="$fax!=''">
							<p>
								<strong>Fax : </strong>
								<xsl:value-of select="objs/obj/obj_common/fax1"/>
							</p>
						</xsl:if>
						
						
							
						<xsl:variable name="email">
							<xsl:value-of select="objs/obj/obj_common/mel1"/>
						</xsl:variable>
						<xsl:if test="$email!=''">
							<p>
								<strong>Email : </strong>
								<a href="mailto:{$email}"><xsl:value-of select="objs/obj/obj_common/mel1"/></a>
							</p>
						</xsl:if>
						
						<xsl:variable name="site">
							<xsl:value-of select="objs/obj/obj_common/site1"/>
						</xsl:variable>
						<xsl:if test="$site!=''">
							<p>
								<strong>Internet : </strong>
								<a href="{$site}"><xsl:value-of select="objs/obj/obj_common/site1"/></a>
							</p>
						</xsl:if>
						
						<xsl:variable name="site_reservation">
							<xsl:value-of select="objs/obj/obj_common/site2"/>
						</xsl:variable>
						<xsl:if test="$site_reservation!=''">
							<a target="_blank" class="bouton" href="{$site_reservation}">Je reserve maintenant</a>
						</xsl:if>
						
						
			</div>
			
			<ul class="diaporama">
				<xsl:for-each select="objs/obj/obj_common/photo/ass_obj_photo">
					<xsl:variable name="image">
						<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_z)"/>
					</xsl:variable>
					<li>
						<img style="width:300px; height:200px" src="{$image}"/>
						<div class="copyright">
							<xsl:value-of select="copyright"/>
						</div>
					</li>
				</xsl:for-each>	
			</ul>
			
		</xsl:if>
		
		<xsl:if test="$image_existante=''">
		
	
	
	<div id="Informations_left">
						<p><xsl:value-of select="objs/obj/adresse1"/></p>
						<p><xsl:value-of select="objs/obj/cp"/> - 
							<xsl:value-of select="objs/obj/localite"/></p>
							
						
						<xsl:variable name="telephone">
							<xsl:value-of select="objs/obj/obj_common/tel1"/>
						</xsl:variable>
						<xsl:if test="$telephone!=''">
							<p>
								<strong>Téléphone : </strong>
								<xsl:value-of select="objs/obj/obj_common/tel1"/>
							</p>
						</xsl:if>	
							
						
						
						<xsl:variable name="fax">
							<xsl:value-of select="objs/obj/obj_common/fax1"/>
						</xsl:variable>
						<xsl:if test="$fax!=''">
							<p>
								<strong>Fax : </strong>
								<xsl:value-of select="objs/obj/obj_common/fax1"/>
							</p>
						</xsl:if>
						
						
							
						<xsl:variable name="email">
							<xsl:value-of select="objs/obj/obj_common/mel1"/>
						</xsl:variable>
						<xsl:if test="$email!=''">
							<p>
								<strong>Email : </strong>
								<a href="mailto:{$email}"><xsl:value-of select="objs/obj/obj_common/mel1"/></a>
							</p>
						</xsl:if>
						
						<xsl:variable name="site">
							<xsl:value-of select="objs/obj/obj_common/site1"/>
						</xsl:variable>
						<xsl:if test="$site!=''">
							<p>
								<strong>Internet : </strong>
								<a href="{$site}"><xsl:value-of select="objs/obj/obj_common/site1"/></a>
							</p>
						</xsl:if>
						
						
			</div>
		</xsl:if>
	
		
	
	<h2> Descriptif</h2>
					<p class="descriptif"><xsl:value-of select="objs/obj/descriptif_fr"/></p>
										
					<xsl:variable name="tarif_mini">
					<xsl:value-of select="objs/obj/obj_common/ass_all_tar[tbl='ass_hot_tarif']/mini_euro"/>
					</xsl:variable>
					<xsl:variable name="tarif_maxi">
					<xsl:value-of select="objs/obj/obj_common/ass_all_tar[tbl='ass_hot_tarif']/maxi_euro"/>
					</xsl:variable>
					<xsl:if test="$tarif_mini!='' or $tarif_maxi!=''">
					<h2>Tarifs</h2>
					<xsl:for-each select="objs/obj/obj_common/ass_all_tar[tbl='ass_hot_tarif']">
						<p>
						<xsl:value-of select="Libelle"/> 
							<xsl:text> : </xsl:text>
							<xsl:variable name="mini_euro">
						<xsl:value-of select="mini_euro"/> 
							</xsl:variable>
							<xsl:variable name="maxi_euro">
						<xsl:value-of select="maxi_euro"/>
							</xsl:variable>
						<xsl:if test="$mini_euro=$maxi_euro">
								Tarif unique de <xsl:value-of select="maxi_euro"/>€
						</xsl:if>
						<xsl:if test="$maxi_euro='' and $mini_euro!=''">
								Tarif à partir de <xsl:value-of select="mini_euro"/>€
						</xsl:if>
						<xsl:if test="$mini_euro='' and $maxi_euro!=''">
								Tarif jusqu'à <xsl:value-of select="maxi_euro"/>€
						</xsl:if>
						<xsl:if test="$maxi_euro!=$mini_euro and $maxi_euro!='' and $mini_euro!=''">
								Tarif à partir de <xsl:value-of select="mini_euro"/>€  jusqu'à <xsl:value-of select="maxi_euro"/>€
						</xsl:if>
						</p>
					</xsl:for-each>
					</xsl:if>	
		
			<div id="equipement">
				<h2> Equipements</h2>
				<ul>
					<xsl:for-each select="objs/obj/obj_common/ass_all[tbl='ass_hot_equipement']|objs/obj/obj_common/ass_all[tbl='ass_hot_confort']">
						<li><xsl:value-of select="Libelle"/></li>
					</xsl:for-each>
				</ul>
			</div>
			<div id="services">
				<h2> Services</h2>
				<ul>
					<xsl:for-each select="objs/obj/obj_common/ass_all[tbl='ass_hot_service']">
						<li><xsl:value-of select="Libelle"/></li>
					</xsl:for-each>
				</ul>
			</div>			
		
	</div>
	
				
</body>
</html>
</xsl:template>
</xsl:stylesheet>
