<?php
// PHP Proxy
// Responds to both HTTP GET and POST requests
//
// Author: Abdul Qabiz
// March 31st, 2006
//

/* gets the contents of a file if it exists, otherwise grabs and caches */
function get_content($file,$url,$hours = 24,$fn = '',$fn_args = '') {
	//vars
	$current_time = time(); $expire_time = $hours * 60 * 60; $file_time = filemtime($file);
	//decisions, decisions
	
	
	if(file_exists($file) && ($current_time - $expire_time < $file_time)) {
		//echo 'returning from cached file';
		//header('HTTP/1.1 304 Not Modified');
		return file_get_contents($file);
	}
	else {
		$content = get_url($url);
		if($fn) { $content = $fn($content,$fn_args); }
		$content.= '<!-- cached:  '.time().'-->';
		file_put_contents($file,$content);
		
		return $content;
	}
}

/* gets content from a URL via curl */
function get_url($url) {
	$ch = curl_init();
	curl_setopt($ch,CURLOPT_URL,$url);
	curl_setopt($ch,CURLOPT_RETURNTRANSFER,1); 
	curl_setopt($ch,CURLOPT_CONNECTTIMEOUT,5);
	$content = curl_exec($ch);
	curl_close($ch);
	return $content;
}

// Get the url of to be proxied
// Is it a POST or a GET?

$url = 'http://webservices.cotedor-tourisme.com/Services.asmx/GetSimpleListeDataXML?ipstrTable=c_obj&ipstrSupport=GP';

//$headers = ($_POST['headers']) ? $_POST['headers'] : $_GET['headers'];
//$mimeType =($_POST['mimeType']) ? $_POST['mimeType'] : $_GET['mimeType'];
$response= get_content("../tmp_xml/search.txt",$url ,3,'','');


 header('Content-type: text/xml');
  // calc an offset of 24 hours
 $offset = 3600 * 3;
 // calc the string in GMT not localtime and add the offset
 $expire = "Expires: " . gmdate("D, d M Y H:i:s", time() + $offset) . " GMT";
 //output the HTTP header
 header($expire);
 header("Cache-Control: max-age=". $offset.", must-revalidate");

echo $response;



?>