<?xml version="1.0" encoding="windows-1256"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:php="http://php.net/xsl"  version="1.0">
    <xsl:output method="text"  encoding="UTF-8"/>

    <xsl:template name="translateDoubleQuotes">
        <xsl:param name="string" select="''" />
        <xsl:choose>
            <xsl:when test="contains($string, '&quot;')">
                <xsl:text />
                <xsl:value-of select="substring-before($string, '&quot;')" />\"<xsl:call-template name="translateDoubleQuotes">
                    <xsl:with-param name="string" select="substring-after($string, '&quot;')" />
                </xsl:call-template>
                <xsl:text />
            </xsl:when>
            <xsl:otherwise>
                <xsl:text />
                <xsl:value-of select="$string" />
                <xsl:text />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="/">    
        {"liste":[   
        <xsl:for-each select="objs/obj">   
            <xsl:choose>
                <xsl:when test="position() = last()">
                    {"id":"<xsl:value-of select="id"/>",
                     "title":"<xsl:call-template name="translateDoubleQuotes">
                        <xsl:with-param name="string" select="societe" />					  
                    </xsl:call-template>  <xsl:call-template name="translateDoubleQuotes">
                        <xsl:with-param name="string" select="localite" />					  
                    </xsl:call-template>" ,
                    "ouverture":"<xsl:value-of select="obj_common/obj_fma_spec/xml_fma_jouverture/obj_fma_ass_ouverture/ouverture_jours"/>",
                    "backgroundColor":"<xsl:value-of select="obj_common/obj_fma_spec/xml_fma_jouverture/obj_fma_ass_ouverture/couleur"/>",
                    "url":"/bourgogne/toutes-les-sorties<xsl:value-of select="php:function('creer_lien_fichev3',string(societe),string(id))"/>"				
                    }
                </xsl:when>
                <xsl:otherwise>                                    
                    {"id":"<xsl:value-of select="id"/>",
                     "title":"<xsl:call-template name="translateDoubleQuotes">
                        <xsl:with-param name="string" select="societe" />					  
                    </xsl:call-template>  <xsl:call-template name="translateDoubleQuotes">
                        <xsl:with-param name="string" select="localite" />					  
                    </xsl:call-template>" ,
                    "ouverture":"<xsl:value-of select="obj_common/obj_fma_spec/xml_fma_jouverture/obj_fma_ass_ouverture/ouverture_jours"/>",
                    "backgroundColor":"<xsl:value-of select="obj_common/obj_fma_spec/xml_fma_jouverture/obj_fma_ass_ouverture/couleur"/>",
                    "url":"/bourgogne/toutes-les-sorties<xsl:value-of select="php:function('creer_lien_fichev3',string(societe),string(id))"/>"				
                    },	
                 </xsl:otherwise>
            </xsl:choose>   			
        </xsl:for-each> 
        ]}
    </xsl:template>
</xsl:stylesheet>

