<?php


$cheminJS=drupal_get_path('module', 'adt21_carte') . '/js';
$cheminCSS=drupal_get_path('module', 'adt21_carte') . '/css'; 
$cheminJSON=drupal_get_path('module', 'adt21_carte') . '/json';

/*-------Liens CSS------*/

drupal_add_css($cheminJS."/Leaflet/dist/leafletcarterdgcclim.css");
drupal_add_css($cheminJS."/label/dist/leaflet.labelcarterdgcclim.css");
drupal_add_css($cheminCSS."/carterdgcclim.css");

/*-------Liens JS-------*/

drupal_add_js($cheminJS."/Leaflet/dist/leaflet.js");
drupal_add_js($cheminJS."/label/dist/leaflet.label.js");
drupal_add_js($cheminJS."/leaflet-google.js");
drupal_add_js($cheminJS."/leaflet-plugins-master/layer/vector/KML.js");

/*-------Liens JSON-------*/

drupal_add_js($cheminJSON."/communes_vignobleAUXOIS.geojson");
drupal_add_js($cheminJSON."/communes_vignobleCHAT.geojson");
drupal_add_js($cheminJSON."/communes_vignobleCHCB.geojson");
drupal_add_js($cheminJSON."/communes_vignobleCHCN.geojson");
drupal_add_js($cheminJSON."/limite_co.geojson");
drupal_add_js($cheminJSON."/rdgc.geojson");
drupal_add_js($cheminJSON."/communes_rdgc.geojson");
drupal_add_js($cheminJSON."/points_communes_rdgc.geojson");
drupal_add_js($cheminJSON."/climats_res.geojson");
drupal_add_js($cheminJSON."/climats_eten.geojson");
drupal_add_js($cheminJSON."/pointcommunesclimats.geojson");
if (current_path()!="awe-content/get-drupal-elements"){
    ?>

    <script>
    (function ($) {
        $(document).ready(function () {

    /*-------------------Gestion generale de la carte*/

          var map = L.map('map',{ zoomControl:false }).setView([47.125, 4.84673095703125], 10);
          map.options.maxZoom = 12;
          map.options.minZoom = 10;
          map.setMaxBounds([[46.853617401905105, 4.571685791015625], [47.3955603961201, 5.121002197265625]]); 

    /*------------------- Ajout fond de carte perso ------------------*/
         var mytile =L.tileLayer('/sites/all/modules/adt21_carte/tuiles/carteclimats/{z}/{x}/{y}.png', {
            maxZoom: 12,
            minZoom: 10,
            tms: false
          }).addTo(map);

    /*-------------------Styles ------------------------*/

            var myStyleRDGC = {
                "color": "#b220b4",
                "weight": 2,
                "opacity": 1
                    };        

            var myStyleRDGC_co = {
                "color": "#000000",
                "fillColor": "#8762ac",
                "weight": 1,
                "opacity": 0,	    
                "fillOpacity": 0.3
                    };         

            var myStylecli_res = {
                "color": "#15C056",
                "fillColor": "#15C056",
                "weight": 1,
                "opacity": 0,	    
                "fillOpacity": 0.3
                    };         

            var myStylecli_eten = {
                "color": "#15C056",
                "fillColor": "#F8FF3C",
                "weight": 1,
                "opacity": 0,	    
                "fillOpacity": 0.5
                    };                     

    /*-------------------Couche Climats---------------------*/  

    <?php if ($typeCarte=="Climats") {?>   

    var Climats = new L.LayerGroup();

    var point_co_CLI = new L.geoJson (point_co_cli, {
                            style: myStyleRDGC_co,
                            onEachFeature:function (feature, layer) {
                                var myIcon2 = L.divIcon({html: '<span>'+feature.properties.name+'</span>', iconSize:null});
                                L.marker([feature.geometry.coordinates[1],feature.geometry.coordinates[0]], {
                                    icon: myIcon2
                                }).addTo(Climats);
                              }});

     var CLI_eten = new L.geoJson (cli_eten, {
                                    style: myStylecli_eten
                                            }).addTo(Climats);   

    var CLI_res = new L.geoJson (cli_res, {
                                    style: myStylecli_res
                                            }).addTo(Climats);  
    Climats.addTo(map);                                        
    <?php }; ?>                                

    /*-------------------Couche RDGC---------------------*/      
    <?php if ($typeCarte=="RDGC") {?>   

    var RDGC = new L.LayerGroup();

    var RDGC_point_co = new L.geoJson (rdgc_point_co, {
                                    style: myStyleRDGC_co,
                                    onEachFeature:function (feature, layer) {
                                        var myIcon = L.divIcon({html: '<a href="https://www.cotedor-tourisme.com/bourgogne/toute-loffre-oenotouristique-de-c%C3%B4te-dor?typeObj=c_obj&strTable=&societe=&ville='+feature.properties.communes_par_vignoble_INSEE+'&dist=0&zone=&recherchecrit=yes&update=Lancer+la+recherche&nbParPage=5&tri=">'+feature.properties.COMMUNE+'<a>', iconSize:null});
                                        L.marker([feature.geometry.coordinates[1],feature.geometry.coordinates[0]], {
                                            icon: myIcon
                                        })
                                     .addTo(RDGC); }});

    var Route = new L.geoJson(rdgc_co, {style: myStyleRDGC_co}).addTo(RDGC); 
    var zone_RDGC = new L.geoJson(rdgc, {style: myStyleRDGC}).addTo(RDGC);

    RDGC.addTo(map);      

    <?php }; ?>  

    /*--------- Legende Carte ---------------------------------*/    
    var legend = L.control({position: 'topleft'}); 

    legend.onAdd = function (map) {
    var div = L.DomUtil.create('div', 'info legend');
        <?php if ($typeCarte=="RDGC") {?>   
        div.innerHTML += '<h4>Route des grands crus</h4><i style="background:#8762ac"></i> Communes <br /><b style="color:#b220b4">&ndash;</b> Route des grands crus';
        <?php } 
        else {?>
        div.innerHTML += '<h4>Climat</h4><i style="background:#F8FF3C"></i> Climat étendu<br /><i style="background:#15C056"></i> Climat restreint';               
        <?php } ?>  
        return div;
    };

    legend.addTo(map);

    new L.Control.Zoom({ position: 'topright' }).addTo(map);

    /*----------------- Agrandissement police lors du zoom --------------------*/
    map.on('zoomend ', function(e) {
        //console.log(map.getZoom());
         if ( map.getZoom() == 10 ){$(".leaflet-marker-icon.leaflet-div-icon.leaflet-clickable.leaflet-zoom-animated").css("font-size","9px");}
         else if ( map.getZoom() <= 11 ){$(".leaflet-marker-icon.leaflet-div-icon.leaflet-clickable.leaflet-zoom-animated").css("font-size","15px");}
         else if ( map.getZoom() > 11 ){$(".leaflet-marker-icon.leaflet-div-icon.leaflet-clickable.leaflet-zoom-animated").css("font-size","25px");}
    });

        });
      }(jQuery));
      </script>
      <div id="map-vignoble-container" >
                        <div id="map">		
			</div>
		
    </div>
 <?php
 }
 else{
     ?>
      
      <div id="map-vignoble-container" >
                        <div id="map" style="background-color:grey;">
                            ICI s'affichera la carte
			</div>
		
    </div>
      
      
      <?php
     
     
 };
 ?>
  <style>
      .leaflet-container a {
          color:black;
          text-decoration: none;
      }
  </style>
	


