<xsl:stylesheet version="1.1" xmlns:kml="https://earth.google.com/kml/2.0"	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:php="http://php.net/xsl"  xmlns:gml="http://www.opengis.net/gml"	 exclude-result-prefixes="php" >
	<!--<xsl:output indent="yes"/>-->

	<xsl:template name="coupe">
		<xsl:param name="s" />
		<xsl:if test="contains($s,' ')">
			<xsl:variable name="s2">
				<xsl:call-template name="coupe">
					<xsl:with-param name="s" select="substring-after($s,' ')"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:value-of select="concat(substring-before($s,' '),' ',$s2)"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="/">
            <xsl:variable name="posDeb">
            <xsl:value-of select="php:function('getDebutListe')"/>
            </xsl:variable>
            <xsl:variable name="posFin">
            <xsl:value-of select="php:function('getFinListe')"/>
            </xsl:variable>
            <xsl:variable name="startPos">
	       <xsl:choose>
                <xsl:when test="string(number($posDeb))='NaN'">0</xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="$posDeb" />
                </xsl:otherwise>
              </xsl:choose>
            </xsl:variable>
            <xsl:variable name="endPos">
	       <xsl:choose>
                <xsl:when test="string(number($posFin))='NaN'">0</xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="$posFin" />
                </xsl:otherwise>
              </xsl:choose>
            </xsl:variable>

		<kml>
                   
			<Document>
					<xsl:for-each select="objs/obj">
                                               
                                                  
                                                  <xsl:if test="position() > (number($startPos)-1) and (position() &lt; (number($endPos)+1))">
                                                   <Placemark>

                                                           <xsl:apply-templates select="obj_common" />
                                                   <description>
                                                                   <xsl:variable name="chemin_photo">
                                                                           <xsl:value-of select="obj_common/photo/ass_obj_photo/fic_m"/>
                                                                   </xsl:variable>

                                                                   <xsl:variable name="test_vignette">
                                                                           <xsl:value-of select="obj_common/photo/ass_obj_photo[vignette=1]/fic_m"/>
                                                                   </xsl:variable>	
                                                                   <xsl:variable name="image">						
                                                                           <xsl:if test="$chemin_photo!=''">								
                                                                                                           <xsl:variable name="chemin">
                                                                                                                   <xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_m,1,4)!='http'">
                                                                                                                           <xsl:if test="$test_vignette!=''">
                                                                                                                                   <xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo[doctype='photo' and vignette=1]/fic_m|obj_common/photo/ass_obj_photo[doctype='Image' and vignette=1]/fic_m)"/>
                                                                                                                           </xsl:if>
                                                                                                                           <xsl:if test="$test_vignette=''">
                                                                                                                                   <xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo[doctype='photo']/fic_m|obj_common/photo/ass_obj_photo[doctype='Image']/fic_m)"/>

                                                                                                                           </xsl:if>
                                                                                                                   </xsl:if>
                                                                                                                   <xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_m,1,4)='http'">
                                                                                                                           <xsl:if test="$test_vignette!=''">
                                                                                                                           <xsl:value-of select="obj_common/photo/ass_obj_photo[vignette=1]/fic_m"/>
                                                                                                                           </xsl:if>
                                                                                                                                   <xsl:if test="$test_vignette=''">
                                                                                                                                           <xsl:value-of select="obj_common/photo/ass_obj_photo/fic_m"/>
                                                                                                                                   </xsl:if>
                                                                                                                   </xsl:if>
                                                                                                           </xsl:variable>https://www.cotedor-tourisme.com/fics_monespacetourisme/redim.php?img_Src=<xsl:value-of select="$chemin" /></xsl:if></xsl:variable>


                                                               <!--<![CDATA[<div style="width:300px;margin-top:1em;font-size:0.85em;line-height:1.5em"><img style="float:right;" src="]]><xsl:value-of select="$image"/><![CDATA["/>]]>-->

                                                                   <!--<![CDATA[<img style="float:right;" src="https://www.cotedor-tourisme.com/fics_monespacetourisme/]]>
                                                                   <xsl:value-of select="obj_common/photo/ass_obj_photo/fic_m"/>
                                                                   <![CDATA["/>]]>-->

                                                                   <xsl:variable name="descriptif">
                                                                           <xsl:value-of select="descriptif_fr"/>
                                                                   </xsl:variable>
                                                                   <xsl:call-template name="coupe">
                                                                           <xsl:with-param name="s" select="substring(normalize-space($descriptif),0,150)"/>
                                                                   </xsl:call-template>
                                                                   <xsl:if test="$descriptif !=''">
                                                                           <xsl:text>...</xsl:text>
                                                                   </xsl:if>

                                                                   <![CDATA[<br />]]>
                                                                   <xsl:if test="adresse1!=''">
                                                                           <xsl:value-of   select="adresse1"/><![CDATA[<br >]]>
                                                                   </xsl:if>
                                                                   <xsl:if test="adresse2!=''">
                                                                           <xsl:value-of   select="adresse2"/><![CDATA[<br >]]>
                                                                   </xsl:if>
                                                                   <xsl:value-of   select="cp"/><![CDATA[ ]]><xsl:value-of   select="localite"/><![CDATA[<br >]]>
                                                                   <xsl:if test="obj_common/tel1!=''">
                                                                           <xsl:text>Tel : </xsl:text><xsl:value-of select="obj_common/tel1"/><![CDATA[<br >]]>
                                                                   </xsl:if>
                                                                   <xsl:if test="obj_common/fax1!=''">
                                                                           <xsl:text>Fax : </xsl:text><xsl:value-of select="obj_common/fax1"/><![CDATA[<br />]]>
                                                                   </xsl:if>
                                                                   <xsl:if test="obj_common/mel1!=''">
                                                                           <xsl:text>Mel : </xsl:text><xsl:value-of select="obj_common/mel1"/><![CDATA[<br />]]>
                                                                   </xsl:if>
                                                                   <xsl:if test="obj_common/horaire!=''">
                                                                           <![CDATA[<i> Horaire : ]]><xsl:value-of select="obj_common/horaire"/><![CDATA[</i><br />]]>
                                                                   </xsl:if>
                                                                   <xsl:variable name="url">
                                                                           <xsl:value-of select="php:function('recuperation_url',string(id), string(societe) )"/>
                                                                   </xsl:variable>
                                                                  <xsl:variable name="verif">
                                                                           <xsl:value-of select="php:function('afficheliendansdesc')"/>
                                                                   </xsl:variable>
                                                                   <xsl:if test="$verif">
                                                                           <xsl:value-of select="$url"/>
                                                                   </xsl:if>
                                                           </description>
                                                           <name>
                                                                   <xsl:value-of select="societe" /><![CDATA[]]>

                                                           </name>
                                                                   <xsl:variable name="id">
                                                                           <xsl:value-of select="id"/>
                                                                   </xsl:variable>
                                                                   <xsl:variable name="log">
                                                                           <id><xsl:value-of select="substring($id,1,3)"/><![CDATA[]]></id>
                                                                   </xsl:variable>
                                                                   
                                                                    <xsl:variable name="codePicto">
                                                                          <xsl:value-of select="php:function('getPicto')"/>
                                                                    </xsl:variable>
                                                                   <xsl:variable name="codeP">
                                                                         <xsl:choose>
                                                                            <xsl:when test="$codePicto='default'">
                                                                                <xsl:value-of select="$log" />
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                              <xsl:value-of select="$codePicto" />
                                                                            </xsl:otherwise>
                                                                          </xsl:choose>                                                                        
                                                                    </xsl:variable>
                                                                     <Style id="FEATURES">
                                                                           <IconStyle>
                                                                                   <Icon>
                                                                                           <color>ffffffff</color>
                                                                                           <href><![CDATA[https://www.cotedor-tourisme.com/pics_communs/icones/gm/]]><xsl:value-of select="$coul_picto" /><xsl:value-of select="$codeP" /><![CDATA[.png]]></href>
                                                                                   </Icon>
                                                                           </IconStyle>
                                                                           <BalloonStyle>
                                                                                   <bgColor>ffffffff</bgColor>
                                                                                   <textColor>ff000000</textColor>
                                                                                   <displayMode>default</displayMode>
                                                                           </BalloonStyle>
                                                                           <LineStyle>
                                                                                   <color><xsl:value-of select="php:function('getColorTrace')"/></color>
                                                                                   <width><xsl:value-of select="php:function('getWidthTrace')"/></width>
                                                                                   </LineStyle>

                                                                           </Style>



                                                   </Placemark>
                                                </xsl:if>
                                           </xsl:for-each>
			</Document>
		</kml>
	</xsl:template>
	

	
	<xsl:variable name="coul_picto">
		<xsl:value-of select="php:function('getCoul')"/>
	</xsl:variable>
	
	<xsl:template match="obj_common" >
	<MultiGeometry>
		<xsl:if test="lng!=''">
			<xsl:if test="lat!=''">
				
				<Point>
					<coordinates>
						<xsl:value-of select="lng" />,<xsl:value-of select="lat" />,0
					</coordinates>
				</Point>
				<!--<xsl:for-each select="objs/obj">
				<h3><xsl:value-of select="id"/></h3>
				</xsl:for-each>-->
				
			</xsl:if>
		</xsl:if>
				<xsl:variable name="ipstrId">
				<xsl:value-of select="php:function('getipstrid')"/>
				</xsl:variable>
				
		<!--<xsl:if test="$ipstrId !='all'">-->
					<xsl:apply-templates  select="gml" />
		<!--</xsl:if>-->
		
		
		</MultiGeometry>
	</xsl:template>
	
	
	<xsl:template match="gml" >
				
						<xsl:apply-templates select="obj_geo" />
						
	</xsl:template>
	<xsl:template match="obj_geo" >
				
						<xsl:apply-templates select="geodata" />
						
	</xsl:template>
	<xsl:template match="geodata" >
		
		<xsl:apply-templates select="gml:MultiCurve" />
		<xsl:apply-templates select="gml:MultiGeometry" />
	</xsl:template>
	
	<xsl:template match="gml:MultiCurve" >
		
		
		<xsl:apply-templates select="gml:curveMembers" />
		
	</xsl:template>
	
	<xsl:template match="gml:curveMembers" >
		<xsl:apply-templates select="gml:LineString" />
	
	</xsl:template>
		<xsl:template match="gml:MultiGeometry" >
		
		
		<xsl:apply-templates select="gml:geometryMembers" />
		
	</xsl:template>
	
	<xsl:template match="gml:geometryMembers" >
		<xsl:apply-templates select="gml:LineString" />
	
	</xsl:template>
	<xsl:template match="gml:LineString" >
		<LineString>
					<coordinates>
						<xsl:value-of select="php:function('coordGML2KML',string(gml:posList))" />
					</coordinates>	
		</LineString>
	</xsl:template>
	
	

</xsl:stylesheet>