
<xsl:stylesheet version="1.1" xmlns:kml="https://earth.google.com/kml/2.0"	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:php="http://php.net/xsl"  xmlns:gml="http://www.opengis.net/gml"	 exclude-result-prefixes="php" >
	<!--<xsl:output indent="yes"/>-->
	
	<xsl:template name="coupe">
		<xsl:param name="s" />
		<xsl:if test="contains($s,' ')">
			<xsl:variable name="s2">
				<xsl:call-template name="coupe">
					<xsl:with-param name="s" select="substring-after($s,' ')"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:value-of select="concat(substring-before($s,' '),' ',$s2)"/>
		</xsl:if>
	</xsl:template>

	<xsl:template match="/">

		<kml>
			<Document>
				<xsl:apply-templates select="objs" />
			</Document>
		</kml>
	</xsl:template>
	
	<xsl:template match="obj">
	
	

		<Placemark>
		
			<xsl:apply-templates select="obj_common" />
		<description>
			<xsl:variable name="chemin_photo">
				<xsl:value-of select="obj_common/photo/ass_obj_photo/fic_m"/>
			</xsl:variable>
			<xsl:variable name="test_vignette">
				<xsl:value-of select="obj_common/photo/ass_obj_photo[vignette=1]/fic_m"/>
			</xsl:variable>
			<xsl:if test="$chemin_photo!=''">

			
				<xsl:variable name="chemin">
					<xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_m,21,3)!='://'">
						<xsl:if test="$test_vignette!=''">
							<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo[doctype='Photo' and vignette=1 and docsstype!='Technique']/fic_m|obj_common/photo/ass_obj_photo[doctype='Image' and vignette=1 and docsstype!='Technique']/fic_m)"/>
						</xsl:if>
						<xsl:if test="$test_vignette=''">
							<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo[doctype='Photo'  and docsstype!='Technique']/fic_m|obj_common/photo/ass_obj_photo[doctype='Image'  and docsstype!='Technique']/fic_m)"/>
								
						</xsl:if>
					</xsl:if>
					<xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_m,21,3)='://'">
						<xsl:if test="$test_vignette!=''">
							<xsl:value-of select="concat('http',substring(obj_common/photo/ass_obj_photo[vignette=1]/fic_m,21))"/>
						</xsl:if>
						<xsl:if test="$test_vignette=''">
							<xsl:value-of select="concat('http',substring(obj_common/photo/ass_obj_photo/fic_m,21))"/>
						</xsl:if>
					</xsl:if>
				</xsl:variable>				
				
				<![CDATA[<img style="float:right;" src="]]><xsl:value-of select="$chemin"/><![CDATA["/>]]>
			</xsl:if>
				
				
				<xsl:variable name="descriptif">
					<xsl:value-of select="descriptif_fr"/>
				</xsl:variable>
				<xsl:if test="$descriptif!=''">
					<xsl:value-of   select="$descriptif"/><![CDATA[<br >]]>
				</xsl:if>
				

				
				<xsl:if test="adresse1!=''">
					<xsl:value-of   select="adresse1"/><![CDATA[<br >]]>
				</xsl:if>
				<xsl:if test="adresse2!=''">
					<xsl:value-of   select="adresse2"/><![CDATA[<br >]]>
				</xsl:if>
				<xsl:value-of   select="cp"/><![CDATA[ ]]><xsl:value-of   select="localite"/><![CDATA[<br >]]>
				<xsl:if test="obj_common/tel1!=''">
					<xsl:text>Tel : </xsl:text><xsl:value-of select="obj_common/tel1"/><![CDATA[<br >]]>
				</xsl:if>
				<xsl:if test="obj_common/fax1!=''">
					<xsl:text>Fax : </xsl:text><xsl:value-of select="obj_common/fax1"/><![CDATA[<br />]]>
				</xsl:if>
				<xsl:if test="obj_common/mel1!=''">
					<xsl:text>Mel : </xsl:text><xsl:value-of select="obj_common/mel1"/><![CDATA[<br />]]>
				</xsl:if>
				<xsl:if test="obj_common/horaire!=''">
					<![CDATA[<i> Horaire : ]]><xsl:value-of select="obj_common/horaire"/><![CDATA[</i><br />]]>
				</xsl:if>
				<xsl:variable name="url">
					<xsl:value-of select="php:function('recuperation_url',string(id), string(societe) )"/>
				</xsl:variable>
				<xsl:variable name="verif">
					<xsl:value-of select="php:function('afficheliendansdesc')"/>
				</xsl:variable>
				<xsl:if test="$verif">
					<![CDATA[<a href="]]><xsl:value-of select="php:function('recuperation_url',string(id), string(societe) )"/><![CDATA[">voir la fiche complète</a>]]>
				</xsl:if>
			</description>
			<name>
				<xsl:value-of select="societe" /><![CDATA[]]>
			</name>
				<xsl:variable name="id">
					<xsl:value-of select="id"/>
				</xsl:variable>
				<xsl:variable name="log">
					<id><xsl:value-of select="substring($id,1,3)"/><![CDATA[]]></id>
				</xsl:variable>
				  <Style id="FEATURES">
					<IconStyle>
						<Icon>
							<color>ffffffff</color>
							<href><![CDATA[https://www.cotedor-tourisme.com/pics_communs/icones/gm/]]><xsl:value-of select="$coul_picto" /><xsl:value-of select="$log" /><![CDATA[.png]]></href>
						</Icon>
					</IconStyle>
					<BalloonStyle>
						<bgColor>ffffffff</bgColor>
						<textColor>ff000000</textColor>
						<displayMode>default</displayMode>
					</BalloonStyle>
					<LineStyle>
						<color><xsl:value-of select="php:function('getColorTrace')"/></color>
						<width><xsl:value-of select="php:function('getWidthTrace')"/></width>
						</LineStyle>
            
					</Style>
				
			
			
		</Placemark>
	</xsl:template>
	
	<xsl:variable name="coul_picto">
		<xsl:value-of select="php:function('getCoul')"/>
	</xsl:variable>
	
	<xsl:template match="obj_common" >
	<MultiGeometry>
		<xsl:if test="lng!=''">
			<xsl:if test="lat!=''">
				
				<Point>
					<coordinates>
						<xsl:value-of select="lng" />,<xsl:value-of select="lat" />,0
					</coordinates>
				</Point>
				<!--<xsl:for-each select="objs/obj">
				<h3><xsl:value-of select="id"/></h3>
				</xsl:for-each>-->
				
			</xsl:if>
		</xsl:if>
				<xsl:variable name="ipstrId">
				<xsl:value-of select="php:function('getipstrid')"/>
				</xsl:variable>
				
		<xsl:if test="$ipstrId !='all'">
					<xsl:apply-templates  select="gml" />
		</xsl:if>
		
		
		</MultiGeometry>
	</xsl:template>
	
	
	<xsl:template match="gml" >
				
						<xsl:apply-templates select="obj_geo" />
						
	</xsl:template>
	<xsl:template match="obj_geo" >
				
						<xsl:apply-templates select="geodata" />
						
	</xsl:template>
	<xsl:template match="geodata" >
		
		<xsl:apply-templates select="gml:MultiCurve" />
		<xsl:apply-templates select="gml:MultiGeometry" />
	</xsl:template>
	
	<xsl:template match="gml:MultiCurve" >
		
		
		<xsl:apply-templates select="gml:curveMembers" />
		
	</xsl:template>
	
	<xsl:template match="gml:curveMembers" >
		<xsl:apply-templates select="gml:LineString" />
	
	</xsl:template>
		<xsl:template match="gml:MultiGeometry" >
		
		
		<xsl:apply-templates select="gml:geometryMembers" />
		
	</xsl:template>
	
	<xsl:template match="gml:geometryMembers" >
		<xsl:apply-templates select="gml:LineString" />
	
	</xsl:template>
	<xsl:template match="gml:LineString" >
		<LineString>
					<coordinates>
						<xsl:value-of select="php:function('coordGML2KML',string(gml:posList))" />
					</coordinates>	
		</LineString>
	</xsl:template>
	
	

</xsl:stylesheet>
