
<xsl:stylesheet version="1.1" xmlns:kml="http://www.opengis.net/kml/2.2"	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:php="http://php.net/xsl"  xmlns:gml="http://www.opengis.net/gml"	 exclude-result-prefixes="php" >
	<!--<xsl:output indent="yes"/>-->
	
	<xsl:template name="coupe">
		<xsl:param name="s" />
		<xsl:if test="contains($s,' ')">
			<xsl:variable name="s2">
				<xsl:call-template name="coupe">
					<xsl:with-param name="s" select="substring-after($s,' ')"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:value-of select="concat(substring-before($s,' '),' ',$s2)"/>
		</xsl:if>
	</xsl:template>

	<xsl:template match="/">

		<kml>
			<Document>
				<xsl:apply-templates select="objs" />
			</Document>
		</kml>
	</xsl:template>
	
	<xsl:template match="obj">
		<Placemark>
		
			<xsl:apply-templates select="obj_common" />

		  <ExtendedData>
				  <Data name="desc">
							<xsl:variable name="chemin_photo">
								<xsl:value-of select="obj_common/photo/ass_obj_photo/fic_m"/>
							</xsl:variable>
							<xsl:variable name="incontournable">
								<xsl:value-of select="obj_common/ass_all[code='INCCLIMATS']/code"/>
							</xsl:variable>
<xsl:value-of select="obj_common/ass_all[code='INCCLIMATS']/code"/>
							<xsl:variable name="test_vignette">
								<xsl:value-of select="obj_common/photo/ass_obj_photo[vignette=1]/fic_m"/>
							</xsl:variable>	
							<xsl:variable name="image">						
								<xsl:if test="$chemin_photo!=''">								
												<xsl:variable name="chemin">
													<xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_m,1,4)!='http'">
														<xsl:if test="$test_vignette!=''">
															<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo[doctype='photo' and vignette=1]/fic_m|obj_common/photo/ass_obj_photo[doctype='Image' and vignette=1]/fic_m)"/>
														</xsl:if>
														<xsl:if test="$test_vignette=''">
															<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo[doctype='photo']/fic_m|obj_common/photo/ass_obj_photo[doctype='Image']/fic_m)"/>
																
														</xsl:if>
													</xsl:if>
													<xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_m,1,4)='http'">
														<xsl:if test="$test_vignette!=''">
														<xsl:value-of select="obj_common/photo/ass_obj_photo[vignette=1]/fic_m"/>
														</xsl:if>
															<xsl:if test="$test_vignette=''">
																<xsl:value-of select="obj_common/photo/ass_obj_photo/fic_m"/>
															</xsl:if>
													</xsl:if>
												</xsl:variable>https://www.cotedor-tourisme.com/fics_monespacetourisme/redim.php?img_Src=<xsl:value-of select="$chemin" /></xsl:if></xsl:variable>
						    
						    
						    <![CDATA[<div style="margin-top:1em;font-size:0.85em;line-height:1.5em"><img style="float:right;" src="]]><xsl:value-of select="$image"/><![CDATA["/>]]>
						    
							<!--<![CDATA[<img style="float:right;" src="https://www.cotedor-tourisme.com/fics_monespacetourisme/]]>
							<xsl:value-of select="obj_common/photo/ass_obj_photo/fic_m"/>
							<![CDATA["/>]]>-->
						<![CDATA[<div class="desc_bulle">]]>
							<xsl:variable name="descriptifclimatscourt">
								<xsl:value-of select="obj_common/siteaff_desc/ass_obj_siteaff_desc[type_descriptif='COURT']/descriptif_spec"/>
							</xsl:variable>
							
							<xsl:variable name="descriptifclimatslong">
								<xsl:value-of select="obj_common/siteaff_desc/ass_obj_siteaff_desc[type_descriptif='LONG']/descriptif_spec"/>
							</xsl:variable>
							
							<xsl:variable name="descriptif">
								<xsl:value-of select="descriptif_fr"/>
							</xsl:variable>
							<xsl:choose>
								<xsl:when test="$descriptifclimatscourt !=''">
									<xsl:value-of select="$descriptifclimatscourt"/>
								</xsl:when>					 
								<xsl:otherwise>
									<xsl:call-template name="coupe">
										<xsl:with-param name="s" select="substring(normalize-space($descriptif),0,150)"/>
									</xsl:call-template>
									<xsl:if test="$descriptif !=''">
										<xsl:text>...</xsl:text>
									</xsl:if>
								</xsl:otherwise>
							</xsl:choose>
							<![CDATA[<br><b>]]>	Descriptif climats long :<![CDATA[</b><br>]]>
							<xsl:value-of select="$descriptifclimatslong" />
						<![CDATA[</div>]]>	
							
						<![CDATA[<div class="info_bulle">]]>
							
							<xsl:if test="adresse1!=''">
								<xsl:value-of   select="adresse1"/><![CDATA[<br >]]>
							</xsl:if>
							<xsl:if test="adresse2!=''">
								<xsl:value-of   select="adresse2"/><![CDATA[<br >]]>
							</xsl:if>
							<xsl:value-of   select="cp"/><![CDATA[ ]]><xsl:value-of   select="localite"/><![CDATA[<br >]]>
							<xsl:if test="obj_common/tel1!=''">
								<xsl:text>Tel : </xsl:text><xsl:value-of select="obj_common/tel1"/><![CDATA[<br >]]>
							</xsl:if>
							<xsl:if test="obj_common/fax1!=''">
								<xsl:text>Fax : </xsl:text><xsl:value-of select="obj_common/fax1"/><![CDATA[<br />]]>
							</xsl:if>
							<xsl:if test="obj_common/mel1!=''">
								<xsl:text>Mel : </xsl:text><xsl:value-of select="obj_common/mel1"/><![CDATA[<br />]]>
							</xsl:if>
							<xsl:if test="obj_common/horaire!=''">
								<![CDATA[<i> Horaires : ]]><xsl:value-of select="obj_common/horaire"/><![CDATA[</i><br />]]>
							</xsl:if>
							<xsl:variable name="url">
								<xsl:value-of select="php:function('recuperation_url',string(id), string(societe) )"/>
							</xsl:variable>
							<xsl:variable name="verif">
								<xsl:value-of select="php:function('afficheliendansdesc')"/>
							</xsl:variable>
							<xsl:if test="$verif">
								<![CDATA[<a href="]]><xsl:value-of select="php:function('recuperation_url',string(id), string(societe) )"/><![CDATA[">voir la fiche complète</a>]]>
							</xsl:if>
						<![CDATA[</div>]]>	
					       </Data>
					       <Data name="idadt21">
					       <xsl:value-of select="id"/>
					        </Data>
						<Data name="incontournable">
						<xsl:value-of select="obj_common/ass_all[code='INCCLIMATS']/code"/>
						</Data>
					       <Data name="descadt21">
					       <xsl:value-of select="descriptif_fr"/>
					        </Data>
					      <Data name="desccourtclimats">
						<value>	<xsl:value-of select="obj_common/siteaff_desc/ass_obj_siteaff_desc[type_descriptif='COURT']/descriptif_spec"/></value>
					      </Data>
					       <Data name="desclongclimats">
						<value>	<xsl:value-of select="obj_common/siteaff_desc/ass_obj_siteaff_desc[type_descriptif='LONG']/descriptif_spec"/></value>
					      </Data>

					      <Data name="cp">
						<value><xsl:value-of   select="cp"/></value>
					      </Data>
					      <Data name="ville">
						<value><xsl:value-of   select="localite"/></value>
					      </Data>
					      
					      <Data name="mail">
						<value><xsl:value-of select="obj_common/mel1"/></value>
					      </Data>
					      
					      <Data name="tel">
						<value><xsl:value-of select="obj_common/tel1"/></value>
					      </Data>
					      <Data name="horaire">
						<value><xsl:value-of select="obj_common/horaire"/></value>
					      </Data>
					      <Data name="urladt21">
						<value><xsl:value-of select="php:function('recuperation_url',string(id), string(societe) )"/></value>
					      </Data>
					      <Data name="imagesClimats">
						<value>
					          <xsl:variable name="image_existante">
							<xsl:value-of select="obj_common/photo/ass_obj_photo[doctype='photo' and divine=0 and nature=0 and type_descriptif='CLIMATS']|obj_common/photo/ass_obj_photo[doctype='Image' and divine=0 and nature=0 and type_descriptif='CLIMATS']"/>
						</xsl:variable>
						<xsl:if test="$image_existante!=''">						
											
								   
							<xsl:for-each select="obj_common/photo/ass_obj_photo[doctype='photo' and divine=0 and nature=0 and type_descriptif='CLIMATS']|obj_common/photo/ass_obj_photo[doctype='Image' and divine=0 and nature=0 and type_descriptif='CLIMATS']">
							<xsl:sort select="ordre" data-type="number"/>
								<xsl:variable name="image">
									<xsl:if test="substring(fic_z,1,4)!='http'">
											<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_z)"/>
									</xsl:if>
									<xsl:if test="substring(fic_z,1,4)='http'">
										<xsl:value-of select="fic_z"/>
									</xsl:if>
								</xsl:variable>
								<xsl:variable name="imagem">
									<xsl:if test="substring(fic_m,1,4)!='http'">
											<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_m)"/>
									</xsl:if>
									<xsl:if test="substring(fic_m,1,4)='http'">
										<xsl:value-of select="fic_m"/>
									</xsl:if>
								</xsl:variable>
								<xsl:variable name="imageo">
									<xsl:if test="substring(fic_o,1,4)!='http'">
										<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_o)"/>
									</xsl:if>
									<xsl:if test="substring(fic_o,1,4)='http'">
										<xsl:value-of select="fic_o"/>
									</xsl:if>
								</xsl:variable>
								<xsl:variable name="copyr">
									<xsl:value-of select="copyright"/>
								</xsl:variable>		
								<xsl:variable name="titre">
									<xsl:value-of select="titre"/>
								</xsl:variable>	
								
								<a href="{$imageo}" >
									<img src="{$imagem}" title="" alt="{$titre} - {$copyr}" class="image1" longdesc="{$imageo}" />
									</a>	
									
													
							</xsl:for-each>	           
										
						</xsl:if>			      
					      
					      
					      </value>
					      </Data>
					      <Data name="imagesADT">
						<value>
					          <xsl:variable name="image_existante">
							<xsl:value-of select="obj_common/photo/ass_obj_photo[doctype='photo' and divine=0 and nature=0 and type_descriptif!='CLIMATS']|obj_common/photo/ass_obj_photo[doctype='Image' and divine=0 and nature=0 and type_descriptif!='CLIMATS']"/>
						</xsl:variable>
						<xsl:if test="$image_existante!=''">						
											
								   
							<xsl:for-each select="obj_common/photo/ass_obj_photo[doctype='photo' and divine=0 and nature=0 and type_descriptif!='CLIMATS']|obj_common/photo/ass_obj_photo[doctype='Image' and divine=0 and nature=0 and type_descriptif!='CLIMATS']">
							<xsl:sort select="ordre" data-type="number"/>
								<xsl:variable name="image">
									<xsl:if test="substring(fic_z,1,4)!='http'">
											<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_z)"/>
									</xsl:if>
									<xsl:if test="substring(fic_z,1,4)='http'">
										<xsl:value-of select="fic_z"/>
									</xsl:if>
								</xsl:variable>
								<xsl:variable name="imagem">
									<xsl:if test="substring(fic_m,1,4)!='http'">
											<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_m)"/>
									</xsl:if>
									<xsl:if test="substring(fic_m,1,4)='http'">
										<xsl:value-of select="fic_m"/>
									</xsl:if>
								</xsl:variable>
								<xsl:variable name="imageo">
									<xsl:if test="substring(fic_o,1,4)!='http'">
										<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',fic_o)"/>
									</xsl:if>
									<xsl:if test="substring(fic_o,1,4)='http'">
										<xsl:value-of select="fic_o"/>
									</xsl:if>
								</xsl:variable>
								<xsl:variable name="copyr">
									<xsl:value-of select="copyright"/>
								</xsl:variable>		
								<xsl:variable name="titre">
									<xsl:value-of select="titre"/>
								</xsl:variable>	
								
								<a href="{$imageo}" >
									<img src="{$imagem}" title="" alt="{$titre} - {$copyr}" class="image1" longdesc="{$imageo}" />
									</a>	
									
													
							</xsl:for-each>	           
										
						</xsl:if>			      
					      
					      
					      </value>
					      </Data>
		 </ExtendedData>
						    
		<name>
			<xsl:value-of select="societe" /><![CDATA[]]>
		</name>
			<xsl:variable name="id">
				<xsl:value-of select="id"/>
			</xsl:variable>
			<xsl:variable name="log">
				<id><xsl:value-of select="substring($id,1,3)"/><![CDATA[]]></id>
			</xsl:variable>
			  <Style id="FEATURES">
				<IconStyle>
					<Icon>
						<color>ffffffff</color>
						<href>
						
							<xsl:choose>
								<xsl:when test="obj_common/ass_all[code='INCCLIMATS']/code='INCCLIMATS'">						
									<![CDATA[https://www.cotedor-tourisme.com/pics_communs/icones/gm/rouge/]]><xsl:value-of select="$log" /><![CDATA[.png]]>
								</xsl:when>					 
								<xsl:otherwise>
									<![CDATA[https://www.cotedor-tourisme.com/pics_communs/icones/gm/]]><xsl:value-of select="$coul_picto" /><xsl:value-of select="$log" /><![CDATA[.png]]>
								</xsl:otherwise>
							</xsl:choose>
						
						</href>
					</Icon>
				</IconStyle>
				
				<LineStyle>
					<color><xsl:value-of select="php:function('getColorTrace')"/></color>
					<width><xsl:value-of select="php:function('getWidthTrace')"/></width>
					</LineStyle>
    
				</Style>
				
			
			
		</Placemark>
	</xsl:template>
	
	<xsl:variable name="coul_picto">
		<xsl:value-of select="php:function('getCoul')"/>
	</xsl:variable>
	
	<xsl:template match="obj_common" >
	<MultiGeometry>
		<xsl:if test="lng!=''">
			<xsl:if test="lat!=''">
				
				<Point>
					<coordinates>
						<xsl:value-of select="lng" />,<xsl:value-of select="lat" />,0
					</coordinates>
				</Point>
				<!--<xsl:for-each select="objs/obj">
				<h3><xsl:value-of select="id"/></h3>
				</xsl:for-each>-->
				
			</xsl:if>
		</xsl:if>
				<xsl:variable name="ipstrId">
				<xsl:value-of select="php:function('getipstrid')"/>
				</xsl:variable>
				
		<!--<xsl:if test="$ipstrId !='all'">-->
					<xsl:apply-templates  select="gml" />
		<!--</xsl:if>-->
		
		
		</MultiGeometry>
	</xsl:template>
	
	
	<xsl:template match="gml" >
				
						<xsl:apply-templates select="obj_geo" />
						
	</xsl:template>
	<xsl:template match="obj_geo" >
				
						<xsl:apply-templates select="geodata" />
						
	</xsl:template>
	<xsl:template match="geodata" >
		
		<xsl:apply-templates select="gml:MultiCurve" />
		<xsl:apply-templates select="gml:MultiGeometry" />
	</xsl:template>
	
	<xsl:template match="gml:MultiCurve" >
		
		
		<xsl:apply-templates select="gml:curveMembers" />
		
	</xsl:template>
	
	<xsl:template match="gml:curveMembers" >
		<xsl:apply-templates select="gml:LineString" />
	
	</xsl:template>
		<xsl:template match="gml:MultiGeometry" >
		
		
		<xsl:apply-templates select="gml:geometryMembers" />
		
	</xsl:template>
	
	<xsl:template match="gml:geometryMembers" >
		<xsl:apply-templates select="gml:LineString" />
	
	</xsl:template>
	<xsl:template match="gml:LineString" >
		<LineString>
					<coordinates>
						<xsl:value-of select="php:function('coordGML2KML',string(gml:posList))" />
					</coordinates>	
		</LineString>
	</xsl:template>
	
	

</xsl:stylesheet>