
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:php="http://php.net/xsl"  xmlns:gml="http://www.opengis.net/gml"	 exclude-result-prefixes="php" >
	<!--<xsl:output indent="yes"/>-->
	<xsl:output method="text" encoding="UTF-8"/>
	<xsl:template name="coupe">
		<xsl:param name="s" />
		<xsl:if test="contains($s,' ')">
			<xsl:variable name="s2">
				<xsl:call-template name="coupe">
					<xsl:with-param name="s" select="substring-after($s,' ')"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:value-of select="concat(substring-before($s,' '),' ',$s2)"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="translateDoubleQuotes">
	<xsl:param name="string" select="''" />

	<xsl:choose>
		<xsl:when test="contains($string, '&quot;')">
			<xsl:text /><xsl:value-of select="substring-before($string, '&quot;')" />\"<xsl:call-template name="translateDoubleQuotes"><xsl:with-param name="string" select="substring-after($string, '&quot;')" /></xsl:call-template><xsl:text />
		</xsl:when>
		<xsl:otherwise>
			<xsl:text /><xsl:value-of select="$string" /><xsl:text />
		</xsl:otherwise>
	</xsl:choose>
	</xsl:template>
	
	
	<xsl:template match="/">
		{
	"type" : "FeatureCollection",
	"features" : [
				<xsl:apply-templates select="objs" />
			]
}</xsl:template>
	<xsl:template match="obj">
				<xsl:variable name="descriptif">
								
					<xsl:call-template name="translateDoubleQuotes">
					    <xsl:with-param name="string" select="descriptif_fr" />					  
					</xsl:call-template>
					
				</xsl:variable>
				<xsl:variable name="nom">
								
					<xsl:call-template name="translateDoubleQuotes">
					    <xsl:with-param name="string" select="societe" />					  
					</xsl:call-template>
					
				</xsl:variable>
				<xsl:variable name="id">
					<xsl:value-of select="id"/>
				</xsl:variable>				
				<xsl:variable name="log">
					<id><xsl:value-of select="substring($id,1,3)"/><![CDATA[]]></id>
				</xsl:variable>			
				<xsl:variable name="url">
					<xsl:value-of select="php:function('recuperation_url',string(id), string(societe) )"/>
				</xsl:variable>
				<xsl:variable name="chemin_photo">
					<xsl:value-of select="obj_common/photo/ass_obj_photo/fic_m"/>
				</xsl:variable>

				<xsl:variable name="test_vignette">
					<xsl:value-of select="obj_common/photo/ass_obj_photo[vignette=1]/fic_m"/>
				</xsl:variable>	
				<xsl:variable name="image">						
					<xsl:if test="$chemin_photo!=''">	
<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo[doctype='photo']/fic_m)"/>					
								<!--	<xsl:variable name="chemin">										
										<xsl:if test="$test_vignette!=''">
											<xsl:if test="substring(obj_common/photo/ass_obj_photo[vignette=1]/fic_m,1,4)!='http'">
												<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo[doctype='photo' and vignette=1]/fic_m)"/>
											</xsl:if>
											<xsl:if test="substring(obj_common/photo/ass_obj_photo[vignette=1]/fic_m,1,4)='http'">
												<xsl:value-of select="obj_common/photo/ass_obj_photo[vignette=1]/fic_m"/>
											</xsl:if>
										</xsl:if>
										<xsl:if test="$test_vignette=''">
											<xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_m,1,4)!='http'">
												<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo[doctype='photo']/fic_m)"/>
											</xsl:if>
											<xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_m,1,4)='http'">
												<xsl:value-of select="obj_common/photo/ass_obj_photo[doctype='photo']/fic_m"/>
											</xsl:if>
										</xsl:if>
									</xsl:variable>
								
								
								<xsl:if test="$test_vignette=''">
									<xsl:variable name="chemin">
										<xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_m,21,3)!='://'">

											<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo/fic_m)"/>
										</xsl:if>
										<xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_m,21,3)='://'">
											<xsl:value-of select="concat('http',substring(obj_common/photo/ass_obj_photo/fic_m,21))"/>

										</xsl:if>
									</xsl:variable>
								</xsl:if>
								<xsl:value-of select="$chemin" />-->
					</xsl:if>
				</xsl:variable>
				<xsl:variable name="verif">
					<xsl:value-of select="php:function('afficheliendansdesc')"/>
				</xsl:variable>{
			"type" : "Feature",
			"properties" : {
				"icon" : "<![CDATA[https://www.cotedor-tourisme.com/pics_communs/icones/gm/rouge/]]><xsl:value-of select="$log" /><![CDATA[.png]]>",
				"iconSize" : [25, 25],
				"iconAnchor" : [13, 13],
				"id" : "<xsl:value-of select="id"/>",
				"codetype" : "<xsl:value-of select="obj_common/CodeType"/>",
				"libelletype" : "<xsl:value-of select="obj_common/libelle_fr"/>",
				"nom" : "<xsl:value-of select="$nom"/>",
				<!--"descriptif_txt" :"<xsl:value-of select="$descriptif"/>",-->
				"adresse1" :"<xsl:call-template name="translateDoubleQuotes">
					    <xsl:with-param name="string" select="normalize-space(adresse1)" />					  
					</xsl:call-template>",
				"adresse2" :"<xsl:call-template name="translateDoubleQuotes">
					    <xsl:with-param name="string" select="normalize-space(adresse2)" />					  
					</xsl:call-template>",
				"cp" : "<xsl:value-of   select="cp"/>",
				"localite" : "<xsl:value-of   select="localite"/>",
				"tel" :"<xsl:value-of select="obj_common/tel1"/>",
				<!--"fax" : "<xsl:value-of select="obj_common/fax1"/>",-->
				"mel" : "<xsl:value-of select="obj_common/mel1"/>",				
				"description" : "<xsl:value-of select="normalize-space($descriptif)"/>",
				"imageurl" : "<xsl:value-of select="$image"/>"
			}<xsl:apply-templates select="obj_common" />},
			
	</xsl:template>
	
			<xsl:template match="obj[last()]">
								<xsl:variable name="chemin_photo">
					<xsl:value-of select="obj_common/photo/ass_obj_photo/fic_m"/>
				</xsl:variable>

				<xsl:variable name="test_vignette">
					<xsl:value-of select="obj_common/photo/ass_obj_photo[vignette=1]/fic_m"/>
				</xsl:variable>	
				<xsl:variable name="image">						
					<xsl:if test="$chemin_photo!=''">	
<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo[doctype='photo']/fic_m)"/>					
								<!--	<xsl:variable name="chemin">										
										<xsl:if test="$test_vignette!=''">
											<xsl:if test="substring(obj_common/photo/ass_obj_photo[vignette=1]/fic_m,1,4)!='http'">
												<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo[doctype='photo' and vignette=1]/fic_m)"/>
											</xsl:if>
											<xsl:if test="substring(obj_common/photo/ass_obj_photo[vignette=1]/fic_m,1,4)='http'">
												<xsl:value-of select="obj_common/photo/ass_obj_photo[vignette=1]/fic_m"/>
											</xsl:if>
										</xsl:if>
										<xsl:if test="$test_vignette=''">
											<xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_m,1,4)!='http'">
												<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo[doctype='photo']/fic_m)"/>
											</xsl:if>
											<xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_m,1,4)='http'">
												<xsl:value-of select="obj_common/photo/ass_obj_photo[doctype='photo']/fic_m"/>
											</xsl:if>
										</xsl:if>
									</xsl:variable>
								
								
								<xsl:if test="$test_vignette=''">
									<xsl:variable name="chemin">
										<xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_m,21,3)!='://'">

											<xsl:value-of select="concat('https://www.cotedor-tourisme.com/fics_monespacetourisme/',obj_common/photo/ass_obj_photo/fic_m)"/>
										</xsl:if>
										<xsl:if test="substring(obj_common/photo/ass_obj_photo/fic_m,21,3)='://'">
											<xsl:value-of select="concat('http',substring(obj_common/photo/ass_obj_photo/fic_m,21))"/>

										</xsl:if>
									</xsl:variable>
								</xsl:if>
								<xsl:value-of select="$chemin" />-->
					</xsl:if>
				</xsl:variable>	
				<xsl:variable name="descriptif">
								
					<xsl:call-template name="translateDoubleQuotes">
					    <xsl:with-param name="string" select="descriptif_fr" />					  
					</xsl:call-template>
					
				</xsl:variable>
				<xsl:variable name="nom">
								
					<xsl:call-template name="translateDoubleQuotes">
					    <xsl:with-param name="string" select="societe" />					  
					</xsl:call-template>
					
				</xsl:variable>
				<xsl:variable name="id">
					<xsl:value-of select="id"/>
				</xsl:variable>
				<xsl:variable name="log">
					<id><xsl:value-of select="substring($id,1,3)"/><![CDATA[]]></id>
				</xsl:variable>			
				<xsl:variable name="url">
					<xsl:value-of select="php:function('recuperation_url',string(id), string(societe) )"/>
				</xsl:variable>
				<xsl:variable name="verif">
					<xsl:value-of select="php:function('afficheliendansdesc')"/>
				</xsl:variable>{
			"type" : "Feature",
			"properties" : {
				"icon" : "<![CDATA[https://www.cotedor-tourisme.com/pics_communs/icones/gm/rouge/]]><xsl:value-of select="$log" /><![CDATA[.png]]>",
				"iconSize" : [25, 25],
				"iconAnchor" : [13, 13],
				"id" : "<xsl:value-of select="id"/>",
				"codetype" : "<xsl:value-of select="obj_common/CodeType"/>",
				"libelletype" : "<xsl:value-of select="obj_common/libelle_fr"/>",
				"nom" : "<xsl:value-of select="$nom"/>",
				<!--"descriptif_txt" :"<xsl:value-of select="$descriptif"/>",-->
				"adresse1" :"<xsl:value-of   select="normalize-space(adresse1)"/>",
				"adresse2" :"<xsl:value-of   select="normalize-space(adresse2)"/>",
				"cp" : "<xsl:value-of   select="cp"/>",
				"localite" : "<xsl:value-of   select="localite"/>",
				"tel" :"<xsl:value-of select="obj_common/tel1"/>",
				<!--"fax" : "<xsl:value-of select="obj_common/fax1"/>",-->
				"mel" : "<xsl:value-of select="obj_common/mel1"/>",				
				"description" : "<xsl:value-of select="normalize-space($descriptif)"/>",
				"imageurl" : "<xsl:value-of select="$image"/>"
			}<xsl:apply-templates select="obj_common" />}
			
	
			</xsl:template>
	<xsl:variable name="coul_picto">
		<xsl:value-of select="php:function('getCoul')"/>
	</xsl:variable>
	
	<xsl:template match="obj_common" >
	
		<xsl:if test="lng!=''">
			<xsl:if test="lat!=''">,
			"geometry" : {
				"type" : "Point",
						"coordinates" : [<xsl:value-of select="lng" />,<xsl:value-of select="lat" />]
					}
			</xsl:if>
		</xsl:if>
				
	
		
		
		
	</xsl:template>
	

	
	

</xsl:stylesheet>