<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:kml="https://earth.google.com/kml/2.0"	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:php="http://php.net/xsl"  xmlns:gml="http://www.opengis.net/gml"	 exclude-result-prefixes="php" >
	<!--<xsl:output indent="yes"/>-->
	
	<xsl:template name="coupe">
		<xsl:param name="s" />
		<xsl:if test="contains($s,' ')">
			<xsl:variable name="s2">
				<xsl:call-template name="coupe">
					<xsl:with-param name="s" select="substring-after($s,' ')"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:value-of select="concat(substring-before($s,' '),' ',$s2)"/>
		</xsl:if>
	</xsl:template>

	<xsl:template match="/">

		<kml>
			<Document>
				<xsl:apply-templates select="objs" />
			</Document>
		</kml>
	</xsl:template>
	
	<xsl:template match="obj">
		<Placemark>
		
			<xsl:apply-templates select="obj_common" />
		<description>
				<xsl:variable name="descriptif">
					<xsl:value-of select="php:function('utf8_encode',string(descriptif_fr))"/>
				</xsl:variable>
				<xsl:variable name="nom">
					<xsl:value-of select="societe"/>
				</xsl:variable>
				<xsl:call-template name="coupe">
					<xsl:with-param name="s" select="substring(normalize-space($descriptif),0,150)"/>
				</xsl:call-template>
				<xsl:if test="$descriptif !=''">
					<xsl:text>...</xsl:text>
				</xsl:if>

			</description>
			<name>
				<xsl:value-of select="php:function('utf8_encode',string(societe))" /><![CDATA[]]>
			</name>
				<xsl:variable name="id">
					<xsl:value-of select="id"/>
				</xsl:variable>
				<xsl:variable name="log">
					<id><xsl:value-of select="substring($id,1,3)"/><![CDATA[]]></id>
				</xsl:variable>
				  <Style id="FEATURES">
					<IconStyle>
						<Icon>
							<color>ffffffff</color>
							<href><![CDATA[https://www.cotedor-tourisme.com/pics_communs/icones/gm/]]><xsl:value-of select="$coul_picto" /><xsl:value-of select="$log" /><![CDATA[.png]]></href>
						</Icon>
					</IconStyle>
					<BalloonStyle>
						<bgColor>ffffffff</bgColor>
						<textColor>ff000000</textColor>
						<displayMode>default</displayMode>
					</BalloonStyle>
					<LineStyle>
						<color><xsl:value-of select="php:function('getColorTrace')"/></color>
						<width><xsl:value-of select="php:function('getWidthTrace')"/></width>
						</LineStyle>
            
					</Style>
				
			
			
		</Placemark>
	</xsl:template>
	
	<xsl:variable name="coul_picto">
		<xsl:value-of select="php:function('getCoul')"/>
	</xsl:variable>
	
	<xsl:template match="obj_common" >
	
		<xsl:if test="lng!=''">
			<xsl:if test="lat!=''">
				
				<Point>
					<coordinates>
						<xsl:value-of select="lng" />,<xsl:value-of select="lat" />,0
					</coordinates>
				</Point>
				<!--<xsl:for-each select="objs/obj">
				<h3><xsl:value-of select="id"/></h3>
				</xsl:for-each>-->
				
			</xsl:if>
		</xsl:if>
				<xsl:variable name="ipstrId">
				<xsl:value-of select="php:function('getipstrid')"/>
				</xsl:variable>
				
		
		
		
		
	</xsl:template>
	
	
	<xsl:template match="gml" >
				
						<xsl:apply-templates select="obj_geo" />
						
	</xsl:template>
	<xsl:template match="obj_geo" >
				
						<xsl:apply-templates select="geodata" />
						
	</xsl:template>
	<xsl:template match="geodata" >
		
		<xsl:apply-templates select="gml:MultiCurve" />
		<xsl:apply-templates select="gml:MultiGeometry" />
	</xsl:template>
	
	<xsl:template match="gml:MultiCurve" >
		
		
		<xsl:apply-templates select="gml:curveMembers" />
		
	</xsl:template>
	
	<xsl:template match="gml:curveMembers" >
		<xsl:apply-templates select="gml:LineString" />
	
	</xsl:template>
		<xsl:template match="gml:MultiGeometry" >
		
		
		<xsl:apply-templates select="gml:geometryMembers" />
		
	</xsl:template>
	
	<xsl:template match="gml:geometryMembers" >
		<xsl:apply-templates select="gml:LineString" />
	
	</xsl:template>
	<xsl:template match="gml:LineString" >
		<LineString>
					<coordinates>
						<xsl:value-of select="php:function('coordGML2KML',string(gml:posList))" />
					</coordinates>	
		</LineString>
	</xsl:template>
	
	

</xsl:stylesheet>