<?php 
class MYPDF extends TCPDF{
     
    //Page header
    public function Header() {
        // Logo
        $image_file = CARNETURL.'/img/pdf_header.png';
        $this->Image($image_file, 10, 2, 190, '', 'png', '', 'T', false, 300, '', true, true, 0, false, false, false);
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}


class concat_pdf extends FPDI {

     var $files = array();
     
     function setFiles($files){
          $this->files = $files;
     }
     
     function addFile($file){
          $this->files []= $file;
     }
     
     function concat(){
          foreach($this->files as $file){
               $pagecount = $this->setSourceFile($file);
               for ($i = 1; $i <= $pagecount; $i++){
                    $tplidx = $this->ImportPage($i);
                    $s = $this->getTemplatesize($tplidx);
                    $this->AddPage('P', array($s['w'], $s['h']));
                    $this->useTemplate($tplidx);
               }
          }
     }

}

?>